/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S6070")
public class EscapeSequenceControlCharacterCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Remove or replace this problematic use of \\c.";
    private static final Pattern WRONG_ESCAPED_SEQUENCE = Pattern.compile("\\\\\\\\c[^@-_]");

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new WrongEscapeSequenceVisitor().visit(regexForLiterals);
    }

    private class WrongEscapeSequenceVisitor
    extends RegexBaseVisitor {
        private WrongEscapeSequenceVisitor() {
        }

        public void visitCharacter(CharacterTree tree) {
            if (WRONG_ESCAPED_SEQUENCE.matcher(tree.getText()).matches()) {
                EscapeSequenceControlCharacterCheck.this.reportIssue((RegexSyntaxElement)tree, EscapeSequenceControlCharacterCheck.MESSAGE, null, Collections.emptyList());
            }
        }
    }
}

