/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4433")
public class LDAPAuthenticatedConnectionCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"put"}).withAnyParameters().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree methodTree) {
        ExpressionTree mechanismTree;
        if (methodTree.arguments().size() != 2) {
            return;
        }
        ExpressionTree putKey = (ExpressionTree)methodTree.arguments().get(0);
        ExpressionTree putValue = (ExpressionTree)methodTree.arguments().get(1);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(putValue);
        ExpressionTree expressionTree = mechanismTree = defaultPropertyValue == null ? putValue : defaultPropertyValue;
        if (LDAPAuthenticatedConnectionCheck.isSecurityAuthenticationConstant(putKey) && LiteralUtils.hasValue((Tree)mechanismTree, (String)"none")) {
            this.reportIssue((Tree)putValue, "Change authentication to \"simple\" or stronger.");
        }
    }

    private static boolean isSecurityAuthenticationConstant(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree constantExpression = (MemberSelectExpressionTree)tree;
            return "javax.naming.Context".equals(constantExpression.expression().symbolType().fullyQualifiedName()) && "SECURITY_AUTHENTICATION".equals(constantExpression.identifier().name());
        }
        return LiteralUtils.hasValue((Tree)tree, (String)"java.naming.security.authentication");
    }
}

