/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5876")
public class SpringSessionFixationCheck
extends AbstractMethodDetection {
    private static final String ISSUE_MSG = "Create a new session during user authentication to prevent session fixation attacks.";

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer$SessionFixationConfigurer"}).names(new String[]{"none"}).addWithoutParametersMatcher().build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree methodInvocation) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)methodInvocation), ISSUE_MSG);
    }

    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        this.reportIssue((Tree)methodReferenceTree.method(), ISSUE_MSG);
    }
}

