/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5976")
public class ParameterizedTestCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Replace these %d tests with a single Parameterized one.";
    private static final Set<String> TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.Test", "org.junit.jupiter.api.Test", "org.testng.annotations.Test"));
    private static final int MIN_SIMILAR_METHODS = 3;
    private static final int MIN_NUMBER_STATEMENTS = 2;
    private static final int MAX_NUMBER_PARAMETER = 3;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List<MethodTree> methods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(ParameterizedTestCheck::isParametrizedCandidate).toList();
        if (methods.size() < 3) {
            return;
        }
        HashSet<MethodTree> handled = new HashSet<MethodTree>();
        for (int i = 0; i < methods.size(); ++i) {
            MethodTree method = methods.get(i);
            if (handled.contains(method)) continue;
            List methodBody = method.block().body();
            CollectAndIgnoreLiterals collectAndIgnoreLiterals = new CollectAndIgnoreLiterals();
            ArrayList<MethodTree> equivalentMethods = new ArrayList<MethodTree>();
            for (int j = i + 1; j < methods.size(); ++j) {
                MethodTree otherMethod = methods.get(j);
                if (handled.contains(otherMethod)) continue;
                boolean areEquivalent = SyntacticEquivalence.areEquivalent((List)methodBody, (List)otherMethod.block().body(), (BiPredicate)collectAndIgnoreLiterals);
                if (areEquivalent) {
                    equivalentMethods.add(otherMethod);
                    collectAndIgnoreLiterals.finishCollect();
                }
                collectAndIgnoreLiterals.clearCurrentNodes();
            }
            this.reportIfIssue(handled, method, collectAndIgnoreLiterals, equivalentMethods);
        }
    }

    private void reportIfIssue(Set<MethodTree> handled, MethodTree method, CollectAndIgnoreLiterals collectAndIgnoreLiterals, List<MethodTree> equivalentMethods) {
        if (equivalentMethods.size() + 1 >= 3) {
            handled.addAll(equivalentMethods);
            int nParameters = collectAndIgnoreLiterals.nodeToParametrize.size();
            if (nParameters <= 3 && method.block().body().size() > nParameters) {
                List secondaries = collectAndIgnoreLiterals.nodeToParametrize.stream().map(param -> new JavaFileScannerContext.Location("Value to parameterize", (Tree)param)).collect(Collectors.toCollection(ArrayList::new));
                equivalentMethods.stream().map(equivalentMethod -> new JavaFileScannerContext.Location("Related test", (Tree)equivalentMethod.simpleName())).forEach(secondaries::add);
                this.reportIssue((Tree)method.simpleName(), String.format(MESSAGE, equivalentMethods.size() + 1), secondaries, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isParametrizedCandidate(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        SymbolMetadata symbolMetadata = methodTree.symbol().metadata();
        if (block == null) return false;
        if (block.body().size() < 2) return false;
        if (!TEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)symbolMetadata).isAnnotatedWith(arg_0))) return false;
        return true;
    }

    static class CollectAndIgnoreLiterals
    implements BiPredicate<JavaTree, JavaTree> {
        Set<JavaTree> nodeToParametrize = new HashSet<JavaTree>();
        private final Set<JavaTree> currentNodeToParameterize = new HashSet<JavaTree>();

        CollectAndIgnoreLiterals() {
        }

        @Override
        public boolean test(JavaTree leftNode, JavaTree rightNode) {
            if (CollectAndIgnoreLiterals.isCompatibleTypes(leftNode, rightNode)) {
                if (!SyntacticEquivalence.areEquivalent((Tree)leftNode, (Tree)rightNode)) {
                    this.currentNodeToParameterize.add(leftNode);
                }
                return true;
            }
            return false;
        }

        public void finishCollect() {
            this.nodeToParametrize.addAll(this.currentNodeToParameterize);
        }

        public void clearCurrentNodes() {
            this.currentNodeToParameterize.clear();
        }

        private static boolean isCompatibleTypes(@Nullable JavaTree leftNode, @Nullable JavaTree rightNode) {
            return leftNode instanceof LiteralTree && rightNode instanceof LiteralTree && (leftNode.is(new Tree.Kind[]{rightNode.kind()}) || leftNode.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL}) && rightNode.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL}));
        }
    }
}

