/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] INCREMENT_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private static final UnresolvedIdentifiersAndSwitchCaseVisitor UNRESOLVED_IDENTIFIERS_AND_SWITCH_CASE_VISITOR = new UnresolvedIdentifiersAndSwitchCaseVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            UNRESOLVED_IDENTIFIERS_AND_SWITCH_CASE_VISITOR.check(tree);
        }
    }

    public void leaveNode(Tree tree) {
        VariableTree variable;
        String name;
        boolean unresolved;
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && !(unresolved = UNRESOLVED_IDENTIFIERS_AND_SWITCH_CASE_VISITOR.isUnresolved(name = (variable = (VariableTree)tree).simpleName().name())) && UnusedLocalVariableCheck.isProperLocalVariable(variable) && UnusedLocalVariableCheck.isUnused(variable.symbol())) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)variable.simpleName()).withMessage(String.format(MESSAGE, name)).withQuickFixes(() -> UnusedLocalVariableCheck.computeQuickFix(variable)).report();
        }
    }

    private static boolean isUnused(Symbol symbol) {
        return symbol.usages().stream().noneMatch(UnusedLocalVariableCheck::isRValue);
    }

    private static boolean isRValue(IdentifierTree tree) {
        Tree parent = UnusedLocalVariableCheck.skipParenthesesUpwards(tree.parent());
        if (parent instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parent;
            return assignment.variable() != tree;
        }
        return !parent.is(INCREMENT_KINDS) || !parent.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private static Tree skipParenthesesUpwards(Tree tree) {
        while (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            tree = tree.parent();
        }
        return tree;
    }

    private static boolean isProperLocalVariable(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return symbol.isLocalVariable() && !symbol.isParameter() && !UnusedLocalVariableCheck.isDefinedInCatchClause(variable) && !UnusedLocalVariableCheck.isTryResource(variable) && !UNRESOLVED_IDENTIFIERS_AND_SWITCH_CASE_VISITOR.isSwitchPatternVariable(variable);
    }

    private static boolean isDefinedInCatchClause(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.CATCH});
    }

    private static boolean isTryResource(VariableTree variable) {
        return variable.parent().is(new Tree.Kind[]{Tree.Kind.LIST}) && variable.parent().parent().is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
    }

    private static List<JavaQuickFix> computeQuickFix(VariableTree variable) {
        return UnusedLocalVariableCheck.getQuickFixTextSpan(variable).map(textSpan -> Collections.singletonList(JavaQuickFix.newQuickFix((String)"Remove unused local variable").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)textSpan)}).build())).orElseGet(Collections::emptyList);
    }

    private static Optional<AnalyzerMessage.TextSpan> getQuickFixTextSpan(VariableTree variable) {
        if (!variable.symbol().usages().isEmpty()) {
            return Optional.empty();
        }
        Tree parent = variable.parent();
        SyntaxToken lastToken = variable.lastToken();
        if (parent.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER})) {
            Optional<VariableTree> followingVariable = QuickFixHelper.nextVariable(variable);
            if (followingVariable.isPresent()) {
                return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.simpleName(), (boolean)true, (Tree)followingVariable.get().simpleName(), (boolean)false));
            }
            Optional<SyntaxToken> precedingComma = UnusedLocalVariableCheck.getPrecedingComma(variable);
            if (precedingComma.isPresent()) {
                AnalyzerMessage.TextSpan value = AnalyzerMessage.textSpanBetween((Tree)((Tree)precedingComma.get()), (boolean)true, (Tree)lastToken, (boolean)false);
                return Optional.of(value);
            }
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.firstToken(), (Tree)lastToken));
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.LIST})) {
            ListTree variables = (ListTree)parent;
            if (variables.size() == 1) {
                return Optional.of(AnalyzerMessage.textSpanFor((Tree)variable));
            }
            if (",".equals(lastToken.text())) {
                return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.simpleName(), (Tree)lastToken));
            }
            SyntaxToken precedingComma = ((VariableTree)variables.get(variables.indexOf((Object)variable) - 1)).lastToken();
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)precedingComma, (Tree)lastToken));
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.TYPE_PATTERN})) {
            return Optional.of(AnalyzerMessage.textSpanFor((Tree)lastToken));
        }
        return Optional.empty();
    }

    private static Optional<SyntaxToken> getPrecedingComma(VariableTree variable) {
        return QuickFixHelper.previousVariable(variable).map(Tree::lastToken);
    }

    private static class UnresolvedIdentifiersAndSwitchCaseVisitor
    extends UnresolvedIdentifiersVisitor {
        private final Set<VariableTree> switchPatternVariables = new HashSet<VariableTree>();
        private boolean withinCaseLabel = false;

        private UnresolvedIdentifiersAndSwitchCaseVisitor() {
        }

        @Override
        public Set<String> check(Tree tree) {
            this.switchPatternVariables.clear();
            this.withinCaseLabel = false;
            return super.check(tree);
        }

        public boolean isSwitchPatternVariable(VariableTree variable) {
            return this.switchPatternVariables.contains(variable);
        }

        public void visitCaseLabel(CaseLabelTree tree) {
            this.withinCaseLabel = true;
            super.visitCaseLabel(tree);
            this.withinCaseLabel = false;
        }

        public void visitVariable(VariableTree tree) {
            if (this.withinCaseLabel) {
                this.switchPatternVariables.add(tree);
            }
            super.visitVariable(tree);
        }
    }
}

