/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2676")
public class AbsOnNegativeCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers MATH_ABS_METHODS = MethodMatchers.create().ofTypes(new String[]{"java.lang.Math"}).names(new String[]{"abs"}).addParametersMatcher(new String[]{"int"}).addParametersMatcher(new String[]{"long"}).build();
    private static final MethodMatchers NEGATIVE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"hashCode"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.util.Random"}).names(new String[]{"nextInt", "nextLong"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Comparable"}).names(new String[]{"compareTo"}).addParametersMatcher(new String[]{"*"}).build()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.UNARY_MINUS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodTree = (MethodInvocationTree)tree;
            if (MATH_ABS_METHODS.matches(methodTree)) {
                ExpressionTree firstArgument = (ExpressionTree)methodTree.arguments().get(0);
                this.checkForIssue(firstArgument);
            }
        } else {
            ExpressionTree operand = ((UnaryExpressionTree)tree).expression();
            this.checkForIssue(operand);
        }
    }

    private void checkForIssue(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            Symbol identifierSymbol = ((MemberSelectExpressionTree)tree).identifier().symbol();
            Type ownerType = identifierSymbol.owner().type();
            if ("MIN_VALUE".equals(identifierSymbol.name()) && (ownerType.is("java.lang.Integer") || ownerType.is("java.lang.Long"))) {
                this.reportIssue((Tree)tree, "Use the original value instead.");
            }
        } else {
            MethodInvocationTree nestedTree = AbsOnNegativeCheck.extractMethodInvocation(tree);
            if (nestedTree != null && NEGATIVE_METHODS.matches(nestedTree)) {
                this.reportIssue((Tree)nestedTree, "Use the original value instead.");
            }
        }
    }

    @CheckForNull
    private static MethodInvocationTree extractMethodInvocation(ExpressionTree tree) {
        ExpressionTree result = tree;
        while (true) {
            if (result.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
                result = ((TypeCastTree)result).expression();
                continue;
            }
            if (!result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) break;
            result = ((ParenthesizedTree)result).expression();
        }
        if (result.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return (MethodInvocationTree)result;
        }
        return null;
    }
}

