/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1170")
public class ConstantsShouldBeStaticFinalCheck
extends IssuableSubscriptionVisitor {
    private int nestedClassesLevel;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void setContext(JavaFileScannerContext context) {
        this.nestedClassesLevel = 0;
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        ++this.nestedClassesLevel;
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTree variableTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !ConstantsShouldBeStaticFinalCheck.staticNonFinal(variableTree = (VariableTree)member) || !ConstantsShouldBeStaticFinalCheck.hasConstantInitializer(variableTree) || this.isObjectInInnerClass(variableTree)) continue;
            this.reportIssue((Tree)variableTree.simpleName(), "Make this final field static too.");
        }
    }

    private boolean isObjectInInnerClass(VariableTree variableTree) {
        if (this.nestedClassesLevel > 1) {
            ExpressionTree initializer = variableTree.initializer();
            return !variableTree.type().is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && !variableTree.symbol().type().is("java.lang.String") || initializer == null || !initializer.asConstant().isPresent();
        }
        return false;
    }

    private static boolean staticNonFinal(VariableTree variableTree) {
        return ConstantsShouldBeStaticFinalCheck.isFinal(variableTree) && !ConstantsShouldBeStaticFinalCheck.isStatic(variableTree);
    }

    public void leaveNode(Tree tree) {
        --this.nestedClassesLevel;
    }

    private static boolean hasConstantInitializer(VariableTree variableTree) {
        MethodReferenceTree methodRef;
        ExpressionTree init = variableTree.initializer();
        if (init == null) {
            return false;
        }
        ExpressionTree deparenthesized = ExpressionUtils.skipParentheses((ExpressionTree)init);
        if (deparenthesized instanceof MethodReferenceTree && ConstantsShouldBeStaticFinalCheck.isInstanceIdentifier((methodRef = (MethodReferenceTree)deparenthesized).expression())) {
            return false;
        }
        return !ConstantsShouldBeStaticFinalCheck.containsChildMatchingPredicate((JavaTree)deparenthesized, ConstantsShouldBeStaticFinalCheck::isNonStaticOrFinal);
    }

    private static boolean isNonStaticOrFinal(Tree tree) {
        return switch (tree.kind()) {
            case Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY, Tree.Kind.ARRAY_ACCESS_EXPRESSION -> true;
            case Tree.Kind.IDENTIFIER -> {
                String name = ((IdentifierTree)tree).name();
                if ("super".equals(name) || "this".equals(name)) {
                    yield true;
                }
                Symbol symbol = ((IdentifierTree)tree).symbol();
                if (!(!symbol.isVariableSymbol() || symbol.isStatic() && symbol.isFinal())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isInstanceIdentifier(Tree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !((IdentifierTree)expression).symbol().isStatic();
    }

    private static boolean containsChildMatchingPredicate(JavaTree tree, Predicate<Tree> predicate) {
        if (predicate.test((Tree)tree)) {
            return true;
        }
        if (!tree.isLeaf()) {
            for (Tree javaTree : tree.getChildren()) {
                if (javaTree == null || !ConstantsShouldBeStaticFinalCheck.containsChildMatchingPredicate((JavaTree)javaTree, predicate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFinal(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC);
    }
}

