/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ObjectFinalizeOverridenCheck", repositoryKey="squid")
@Rule(key="S1113")
public class ObjectFinalizeOverriddenCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers FINALIZE_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Object"}).names(new String[]{"finalize"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (FINALIZE_MATCHER.matches(methodTree) && ObjectFinalizeOverriddenCheck.isNotFinalOrHasNonEmptyBody(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Do not override the Object.finalize() method.");
        }
    }

    private static boolean isNotFinalOrHasNonEmptyBody(MethodTree methodTree) {
        return !ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.FINAL) || !Objects.requireNonNull(methodTree.block()).body().isEmpty();
    }
}

