/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6923")
public class UseMotionSensorWithoutGyroscopeCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Replace `TYPE_ROTATION_VECTOR` (11) with `TYPE_GEOMAGNETIC_ROTATION_VECTOR` (20) to optimize battery life.";
    private static final int TYPE_ROTATION_VECTOR = 11;
    private static final MethodMatchers GET_DEFAULT_SENSOR_MATCHER = MethodMatchers.create().ofTypes(new String[]{"android.hardware.SensorManager"}).names(new String[]{"getDefaultSensor"}).withAnyParameters().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return GET_DEFAULT_SENSOR_MATCHER;
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ((ExpressionTree)mit.arguments().get(0)).asConstant(Integer.class).filter(argValue -> argValue == 11).ifPresent(unused -> this.reportIssue((Tree)mit, MESSAGE));
    }
}

