/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6833")
public class ControllerWithRestControllerReplacementCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Optional<AnnotationTree> annotation = classTree.modifiers().annotations().stream().filter(a -> "org.springframework.stereotype.Controller".equals(a.annotationType().symbolType().fullyQualifiedName())).findFirst();
        if (annotation.isEmpty()) {
            return;
        }
        ArrayList secondaryLocations = new ArrayList();
        ArrayList edits = new ArrayList();
        classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).forEach(method -> {
            Optional<AnnotationTree> methodAnnotation = method.modifiers().annotations().stream().filter(a -> "org.springframework.web.bind.annotation.ResponseBody".equals(a.annotationType().symbolType().fullyQualifiedName())).findFirst();
            methodAnnotation.ifPresent(annotationTree -> secondaryLocations.add(new JavaFileScannerContext.Location("Remove this \"@ResponseBody\" annotation.", (Tree)annotationTree)));
            methodAnnotation.ifPresent(annotationTree -> edits.add(JavaTextEdit.removeTree((Tree)annotationTree)));
        });
        classTree.modifiers().annotations().stream().filter(a -> "org.springframework.web.bind.annotation.ResponseBody".equals(a.annotationType().symbolType().fullyQualifiedName())).forEach(annotationTree -> secondaryLocations.add(new JavaFileScannerContext.Location("Remove this \"@ResponseBody\" annotation.", (Tree)annotationTree)));
        if (secondaryLocations.isEmpty()) {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)annotation.get()).withMessage("Replace the \"@Controller\" annotation by \"@RestController\" and remove all \"@ResponseBody\" annotations.").withSecondaries(secondaryLocations).withQuickFixes(() -> List.of(JavaQuickFix.newQuickFix((String)"Remove \"@ResponseBody\" annotations.").addTextEdits(edits).build(), JavaQuickFix.newQuickFix((String)"Replace \"@Controller\" by \"@RestController\".").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)((Tree)annotation.get()), (String)"@RestController")}).build())).report();
    }
}

