/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125")
public class BooleanLiteralCheck
extends IssuableSubscriptionVisitor {
    private static final String FALSE_LITERAL = "false";
    private static final String TRUE_LITERAL = "true";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        ConditionalExpressionTree expression;
        List<LiteralTree> literalList;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{((UnaryExpressionTree)tree).expression()});
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            expression = (ConditionalExpressionTree)tree;
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{expression.trueExpression(), expression.falseExpression()});
        } else {
            expression = (BinaryExpressionTree)tree;
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{expression.leftOperand(), expression.rightOperand()});
        }
        int nLiterals = literalList.size();
        if (nLiterals > 0) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)literalList.get(0)).withMessage("Remove the unnecessary boolean literal%s.", new Object[]{nLiterals > 1 ? "s" : ""}).withSecondaries(literalList.stream().skip(1L).map(lit -> new JavaFileScannerContext.Location("", (Tree)lit)).collect(Collectors.toList())).withQuickFixes(() -> BooleanLiteralCheck.getQuickFix(tree)).report();
        }
    }

    private static List<LiteralTree> getBooleanLiterals(Tree ... trees) {
        ArrayList<LiteralTree> booleanLiterals = new ArrayList<LiteralTree>();
        for (Tree t : trees) {
            if (t.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                return Collections.emptyList();
            }
            if (!t.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) continue;
            booleanLiterals.add((LiteralTree)t);
        }
        return booleanLiterals;
    }

    private static List<JavaQuickFix> getQuickFix(Tree tree) {
        List<JavaTextEdit> edits;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            edits = BooleanLiteralCheck.editsForConditionalExpression((ConditionalExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            String booleanValue = ((LiteralTree)((UnaryExpressionTree)tree).expression()).value();
            edits = new ArrayList<JavaTextEdit>();
            edits.add(JavaTextEdit.replaceTree((Tree)tree, (String)(TRUE_LITERAL.equals(booleanValue) ? FALSE_LITERAL : TRUE_LITERAL)));
        } else {
            edits = tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) ? BooleanLiteralCheck.editsForEquality((BinaryExpressionTree)tree, true) : (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) ? BooleanLiteralCheck.editsForEquality((BinaryExpressionTree)tree, false) : (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) ? BooleanLiteralCheck.editsForConditional((BinaryExpressionTree)tree, true) : BooleanLiteralCheck.editsForConditional((BinaryExpressionTree)tree, false)));
        }
        if (edits.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(JavaQuickFix.newQuickFix((String)"Simplify the expression").addTextEdits(edits).build());
    }

    private static List<JavaTextEdit> editsForConditionalExpression(ConditionalExpressionTree tree) {
        List<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        Boolean left = BooleanLiteralCheck.getBooleanValue((Tree)tree.trueExpression());
        Boolean right = BooleanLiteralCheck.getBooleanValue((Tree)tree.falseExpression());
        if (left != null) {
            if (right != null) {
                edits = BooleanLiteralCheck.editsForConditionalBothLiterals(tree, left, right);
            } else {
                String operator;
                if (left.booleanValue()) {
                    operator = "||";
                } else {
                    operator = "&&";
                    edits.add(JavaTextEdit.insertBeforeTree((Tree)tree.condition(), (String)"!"));
                }
                edits.add(JavaTextEdit.replaceBetweenTree((Tree)tree.questionToken(), (Tree)tree.colonToken(), (String)operator));
            }
        } else if (right != null) {
            String operator;
            edits.add(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)tree.trueExpression(), (boolean)false, (Tree)tree.falseExpression(), (boolean)true)));
            if (right.booleanValue()) {
                operator = "||";
                edits.add(JavaTextEdit.insertBeforeTree((Tree)tree.condition(), (String)"!"));
            } else {
                operator = "&&";
            }
            edits.add(JavaTextEdit.replaceTree((Tree)tree.questionToken(), (String)operator));
        }
        return edits;
    }

    private static List<JavaTextEdit> editsForConditionalBothLiterals(ConditionalExpressionTree tree, Boolean left, Boolean right) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        JavaTextEdit editRemoveExpressions = JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)tree.condition(), (boolean)false, (Tree)tree.falseExpression(), (boolean)true));
        if (left.booleanValue() && !right.booleanValue()) {
            edits.add(editRemoveExpressions);
        } else if (!left.booleanValue() && right.booleanValue()) {
            edits.add(editRemoveExpressions);
            edits.add(JavaTextEdit.insertBeforeTree((Tree)tree, (String)"!"));
        }
        return edits;
    }

    private static List<JavaTextEdit> editsForEquality(BinaryExpressionTree tree, boolean equalToOperator) {
        List<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        ExpressionTree leftOperand = tree.leftOperand();
        ExpressionTree rightOperand = tree.rightOperand();
        Boolean left = BooleanLiteralCheck.getBooleanValue((Tree)leftOperand);
        Boolean right = BooleanLiteralCheck.getBooleanValue((Tree)rightOperand);
        if (left != null) {
            if (right != null) {
                edits.add(BooleanLiteralCheck.editForEqualityWhenBothLiterals(tree, left, right, equalToOperator));
            } else {
                if (!left.booleanValue()) {
                    equalToOperator = !equalToOperator;
                }
                edits.add(JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)true, (Tree)rightOperand, (boolean)false), (String)(equalToOperator ? "" : "!")));
            }
        } else if (right != null) {
            edits = BooleanLiteralCheck.editsForEqualityWhenRightIsLiteral(right, leftOperand, rightOperand, equalToOperator);
        }
        return edits;
    }

    private static JavaTextEdit editForEqualityWhenBothLiterals(BinaryExpressionTree tree, Boolean left, Boolean right, boolean equalToOperator) {
        if (!left.equals(right)) {
            equalToOperator = !equalToOperator;
        }
        return JavaTextEdit.replaceTree((Tree)tree, (String)(equalToOperator ? TRUE_LITERAL : FALSE_LITERAL));
    }

    private static List<JavaTextEdit> editsForEqualityWhenRightIsLiteral(Boolean right, ExpressionTree leftOperand, ExpressionTree rightOperand, boolean equalToOperator) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        if (!right.equals(equalToOperator)) {
            edits.add(JavaTextEdit.insertBeforeTree((Tree)leftOperand, (String)"!"));
        }
        edits.add(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)false, (Tree)rightOperand, (boolean)true)));
        return edits;
    }

    private static List<JavaTextEdit> editsForConditional(BinaryExpressionTree tree, boolean conditionalOr) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        ExpressionTree leftOperand = tree.leftOperand();
        ExpressionTree rightOperand = tree.rightOperand();
        Boolean left = BooleanLiteralCheck.getBooleanValue((Tree)leftOperand);
        Boolean right = BooleanLiteralCheck.getBooleanValue((Tree)rightOperand);
        if (left != null) {
            if (right != null) {
                edits.add(BooleanLiteralCheck.editForConditionalWhenBothLiterals(tree, left, right, conditionalOr));
            } else {
                AnalyzerMessage.TextSpan textSpanToRemove = conditionalOr == left ? AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)false, (Tree)rightOperand, (boolean)true) : AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)true, (Tree)rightOperand, (boolean)false);
                edits.add(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)textSpanToRemove));
            }
        } else if (right != null) {
            BooleanLiteralCheck.editForConditionalWhenRightIsLiteral(right, leftOperand, rightOperand, conditionalOr).ifPresent(edits::add);
        }
        return edits;
    }

    @Nullable
    private static Boolean getBooleanValue(Tree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return Boolean.parseBoolean(((LiteralTree)expression).value());
        }
        return null;
    }

    private static JavaTextEdit editForConditionalWhenBothLiterals(BinaryExpressionTree tree, Boolean left, Boolean right, boolean conditionalOr) {
        boolean conditionalAnd = !conditionalOr;
        boolean simplification = conditionalOr && (left != false || right != false) || conditionalAnd && left != false && right != false;
        return JavaTextEdit.replaceTree((Tree)tree, (String)(simplification ? TRUE_LITERAL : FALSE_LITERAL));
    }

    private static Optional<JavaTextEdit> editForConditionalWhenRightIsLiteral(Boolean right, ExpressionTree leftOperand, ExpressionTree rightOperand, boolean conditionalOr) {
        AnalyzerMessage.TextSpan textSpanToRemove;
        if (right.equals(conditionalOr)) {
            if (BooleanLiteralCheck.mayHaveSideEffect((Tree)leftOperand)) {
                return Optional.empty();
            }
            textSpanToRemove = AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)true, (Tree)rightOperand, (boolean)false);
        } else {
            textSpanToRemove = AnalyzerMessage.textSpanBetween((Tree)leftOperand, (boolean)false, (Tree)rightOperand, (boolean)true);
        }
        return Optional.of(JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)textSpanToRemove));
    }

    private static boolean mayHaveSideEffect(Tree tree) {
        MethodInvocationFinder methodInvocationFinder = new MethodInvocationFinder();
        tree.accept((TreeVisitor)methodInvocationFinder);
        return methodInvocationFinder.found;
    }

    private static class MethodInvocationFinder
    extends BaseTreeVisitor {
        boolean found = false;

        private MethodInvocationFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.found = true;
        }
    }
}

