/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6204")
public class CollectorsToListCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String MESSAGE = "Replace this usage of 'Stream.collect(Collectors.%s())' with 'Stream.toList()'";
    private static final MethodMatchers COLLECT = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Stream"}).names(new String[]{"collect"}).addParametersMatcher(new String[]{"java.util.stream.Collector"}).build();
    private static final MethodMatchers COLLECTORS_TO_LIST = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Collectors"}).names(new String[]{"toList"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers COLLECTORS_TO_UNMODIFIABLE_LIST = MethodMatchers.create().ofSubTypes(new String[]{"java.util.stream.Collectors"}).names(new String[]{"toUnmodifiableList"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers LIST_MODIFICATION_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"java.util.List"}).names(new String[]{"add", "addAll", "remove", "removeAll", "retainAll", "replaceAll", "set", "sort", "clear", "removeIf"}).withAnyParameters().build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava16Compatible();
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return COLLECT;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean mutable;
        if (!((ExpressionTree)mit.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return;
        }
        MethodInvocationTree collector = (MethodInvocationTree)mit.arguments().get(0);
        if (COLLECTORS_TO_LIST.matches(collector)) {
            mutable = true;
        } else if (COLLECTORS_TO_UNMODIFIABLE_LIST.matches(collector)) {
            mutable = false;
        } else {
            return;
        }
        Symbol assignedVariable = CollectorsToListCheck.findAssignedVariable(mit.parent());
        if (!mutable || assignedVariable == null || assignedVariable.usages().stream().noneMatch(CollectorsToListCheck::isListBeingModified)) {
            this.reportIssue(collector, mutable);
        }
    }

    private void reportIssue(MethodInvocationTree collector, boolean mutable) {
        String message = String.format(MESSAGE, mutable ? "toList" : "toUnmodifiableList");
        this.reportIssue((Tree)collector, message);
    }

    private static boolean isListBeingModified(Tree list) {
        while (list.parent().is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION, Tree.Kind.MEMBER_SELECT})) {
            Tree possibleMethodInvocation = list.parent().parent();
            if (possibleMethodInvocation.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)possibleMethodInvocation;
                ExpressionTree receiver = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
                return receiver == list && LIST_MODIFICATION_METHODS.matches(mit);
            }
            list = list.parent();
        }
        return false;
    }

    @CheckForNull
    private static Symbol findAssignedVariable(Tree tree) {
        switch (tree.kind()) {
            case ASSIGNMENT: {
                return CollectorsToListCheck.findAssignedVariable((Tree)((AssignmentExpressionTree)tree).variable());
            }
            case VARIABLE: {
                return ((VariableTree)tree).symbol();
            }
            case IDENTIFIER: {
                return ((IdentifierTree)tree).symbol();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectExpressionTree)tree).identifier().symbol();
            }
            case ARRAY_ACCESS_EXPRESSION: {
                return CollectorsToListCheck.findAssignedVariable((Tree)((ArrayAccessExpressionTree)tree).expression());
            }
        }
        return null;
    }
}

