/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2094")
public class EmptyClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null && EmptyClassCheck.isNotExtending(classTree) && EmptyClassCheck.isEmpty(classTree)) {
            this.reportIssue((Tree)simpleName, "Remove this empty class, write its code or make it an \"interface\".");
        }
    }

    private static boolean isNotExtending(ClassTree tree) {
        return tree.superClass() == null && tree.superInterfaces().isEmpty();
    }

    private static boolean isEmpty(ClassTree tree) {
        return tree.modifiers().annotations().isEmpty() && tree.recordComponents().isEmpty() && tree.members().stream().allMatch(member -> member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT}));
    }
}

