/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1186")
public class EmptyMethodsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.RECORD);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            List members = classTree.members();
            this.checkMethods(members);
            this.checkSingleNoArgPublicConstructor(members);
        }
    }

    private void checkMethods(List<Tree> members) {
        members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).forEach(this::checkMethod);
    }

    private void checkSingleNoArgPublicConstructor(List<Tree> members) {
        List constructors = members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(MethodTree.class::cast).collect(Collectors.toList());
        if (constructors.size() == 1 && EmptyMethodsCheck.isPublicNoArgConstructor((MethodTree)constructors.get(0))) {
            this.checkMethod((MethodTree)constructors.get(0));
        }
    }

    private static boolean isPublicNoArgConstructor(MethodTree constructor) {
        return ModifiersUtils.hasModifier((ModifiersTree)constructor.modifiers(), (Modifier)Modifier.PUBLIC) && constructor.parameters().isEmpty();
    }

    private void checkMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && EmptyMethodsCheck.isEmpty(block) && !EmptyMethodsCheck.containsComment(block)) {
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)methodTree.simpleName()).withMessage("Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.").withQuickFix(() -> EmptyMethodsCheck.computeQuickFix(methodTree)).report();
        }
    }

    private static boolean isEmpty(BlockTree block) {
        List body = block.body();
        return body.isEmpty() || body.stream().allMatch(stmt -> stmt.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT}));
    }

    private static boolean containsComment(BlockTree block) {
        return !block.closeBraceToken().trivias().isEmpty();
    }

    private static JavaQuickFix computeQuickFix(MethodTree method) {
        Object commentFormat;
        if (method.block().openBraceToken().range().start().line() == method.block().closeBraceToken().range().start().line()) {
            commentFormat = " /* TODO document why this %s is empty */ ";
        } else {
            String methodPadding = EmptyMethodsCheck.computePadding(method);
            commentFormat = "\n" + methodPadding + "  // TODO document why this %s is empty\n" + methodPadding;
        }
        String comment = String.format((String)commentFormat, method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) ? "constructor" : "method");
        AnalyzerMessage.TextSpan textSpan = AnalyzerMessage.textSpanBetween((Tree)method.block().openBraceToken(), (boolean)false, (Tree)method.block().closeBraceToken(), (boolean)false);
        return JavaQuickFix.newQuickFix((String)"Insert placeholder comment").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)textSpan, (String)comment)}).build();
    }

    private static String computePadding(MethodTree method) {
        int spaces = method.firstToken().range().start().columnOffset();
        StringBuilder padding = new StringBuilder("");
        for (int i = 0; i < spaces; ++i) {
            padding.append(" ");
        }
        return padding.toString();
    }
}

