/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4454")
public class EqualsParametersMarkedNonNullCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!MethodTreeUtils.isEqualsMethod(methodTree)) {
            return;
        }
        VariableTree variable = (VariableTree)methodTree.parameters().get(0);
        SymbolMetadata.NullabilityData nullabilityData = variable.symbol().metadata().nullabilityData();
        SymbolMetadata.AnnotationInstance annotation = nullabilityData.annotation();
        Tree annotationTree = nullabilityData.declaration();
        if (annotationTree != null && annotation != null && nullabilityData.isNonNull(SymbolMetadata.NullabilityLevel.VARIABLE, true, false)) {
            String annotationName = annotation.symbol().name();
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree(annotationTree).withMessage("\"equals\" method parameters should not be marked \"@%s\".", new Object[]{annotationName}).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove \"@%s\"", (Object[])new Object[]{annotationName}).addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)annotationTree, (boolean)true, (Tree)QuickFixHelper.nextToken(annotationTree), (boolean)false))}).build()).report();
        }
    }
}

