/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S1488")
public class ImmediatelyReturnedVariableCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<Tree.Kind, String> MESSAGE_KEYS = MapBuilder.newMap().put((Object)Tree.Kind.THROW_STATEMENT, (Object)"throw").put((Object)Tree.Kind.RETURN_STATEMENT, (Object)"return").build();
    private JavaFileScannerContext context;
    private String lastTypeForMessage;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        super.visitBlock(tree);
        List statements = tree.body();
        int size = statements.size();
        if (size < 2) {
            return;
        }
        StatementTree butLastStatement = (StatementTree)statements.get(size - 2);
        if (butLastStatement.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            String identifier;
            VariableTree variableTree = (VariableTree)butLastStatement;
            if (!variableTree.modifiers().annotations().isEmpty()) {
                return;
            }
            StatementTree lastStatement = (StatementTree)statements.get(size - 1);
            String lastStatementIdentifier = this.getReturnOrThrowIdentifier(lastStatement);
            if (lastStatementIdentifier != null && StringUtils.equals((String)lastStatementIdentifier, (String)(identifier = variableTree.simpleName().name()))) {
                ExpressionTree initializer = variableTree.initializer();
                if (initializer == null) {
                    return;
                }
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)initializer).withMessage("Immediately %s this expression instead of assigning it to the temporary variable \"%s\".", new Object[]{this.lastTypeForMessage, identifier}).withQuickFix(() -> ImmediatelyReturnedVariableCheck.quickFix(butLastStatement, lastStatement, variableTree, this.lastTypeForMessage)).report();
            }
        }
    }

    private static JavaQuickFix quickFix(StatementTree butLastStatement, StatementTree lastStatement, VariableTree variableTree, String lastTypeForMessage) {
        return JavaQuickFix.newQuickFix((String)"Inline expression").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)variableTree.modifiers(), (boolean)true, (Tree)variableTree.initializer(), (boolean)false), (String)(lastTypeForMessage + " ")), JavaTextEdit.removeTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)butLastStatement, (boolean)false, (Tree)lastStatement, (boolean)true))}).build();
    }

    @CheckForNull
    private String getReturnOrThrowIdentifier(StatementTree lastStatementOfBlock) {
        this.lastTypeForMessage = null;
        ExpressionTree expr = null;
        if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.THROW_STATEMENT);
            expr = ((ThrowStatementTree)lastStatementOfBlock).expression();
        } else if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.RETURN_STATEMENT);
            expr = ((ReturnStatementTree)lastStatementOfBlock).expression();
        }
        if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expr).name();
        }
        return null;
    }
}

