/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S2864")
public class KeySetInsteadOfEntrySetCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers MAP_GET_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"get"}).addParametersMatcher(new String[]{"java.lang.Object"}).build();
    private static final MethodMatchers MAP_KEYSET_METHOD = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"}).names(new String[]{"keySet"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.FOR_EACH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree;
        Symbol ownerSymbol;
        ForEachStatement forEachTree = (ForEachStatement)tree;
        ExpressionTree expressionTree = forEachTree.expression();
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (ownerSymbol = KeySetInsteadOfEntrySetCheck.getOwnerSymbol(methodTree = (MethodInvocationTree)expressionTree)) != null && MAP_KEYSET_METHOD.matches(methodTree)) {
            new GetUsageVisitor().isCallingGetWithSymbol(forEachTree, forEachTree.variable().symbol(), ownerSymbol);
        }
    }

    @CheckForNull
    private static Symbol getOwnerSymbol(MethodInvocationTree tree) {
        ExpressionTree expressionTree = tree.methodSelect();
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return tree.symbol().owner();
        }
        expressionTree = ((MemberSelectExpressionTree)expressionTree).expression();
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expressionTree).symbol();
        }
        return KeySetInsteadOfEntrySetCheck.getFieldAccessedUsingSuperOrThis(expressionTree);
    }

    @CheckForNull
    private static Symbol getFieldAccessedUsingSuperOrThis(ExpressionTree expressionTree) {
        String identifierText;
        MemberSelectExpressionTree memberSelectTree;
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (memberSelectTree = (MemberSelectExpressionTree)expressionTree).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ("super".equals(identifierText = ((IdentifierTree)memberSelectTree.expression()).identifierToken().text()) || "this".equals(identifierText))) {
            return memberSelectTree.identifier().symbol();
        }
        return null;
    }

    private class GetUsageVisitor
    extends BaseTreeVisitor {
        private Symbol variable;
        private boolean result;
        private Symbol mapSymbol;

        private GetUsageVisitor() {
        }

        public void isCallingGetWithSymbol(ForEachStatement forEachTree, Symbol variable, Symbol mapSymbol) {
            this.variable = variable;
            this.result = false;
            this.mapSymbol = mapSymbol;
            this.scan((Tree)forEachTree.statement());
            if (this.result) {
                KeySetInsteadOfEntrySetCheck.this.reportIssue((Tree)forEachTree.forKeyword(), "Iterate over the \"entrySet\" instead of the \"keySet\".");
            }
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (MAP_GET_METHOD.matches(tree)) {
                Tree firstArgument = (Tree)ListUtils.getOnlyElement((List)tree.arguments());
                if (this.mapSymbol.equals(KeySetInsteadOfEntrySetCheck.getOwnerSymbol(tree)) && firstArgument.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)firstArgument).symbol().equals(this.variable)) {
                    this.result = true;
                    return;
                }
            }
            super.visitMethodInvocation(tree);
        }
    }
}

