/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.AccessorsUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S4144")
public class MethodIdenticalImplementationsCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MSG = "Update this method so that its implementation is not identical to \"%s\" on line %d.";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List methods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(methodTree -> MethodIdenticalImplementationsCheck.isDuplicateCandidate(methodTree, classTree)).map(MethodWithUsedVariables::new).collect(Collectors.toList());
        if (methods.size() <= 1) {
            return;
        }
        HashSet reported = new HashSet();
        for (int i = 0; i < methods.size(); ++i) {
            MethodWithUsedVariables methodWithVariables = (MethodWithUsedVariables)((Object)methods.get(i));
            MethodTree method = methodWithVariables.method;
            SyntaxToken methodIdentifier = method.simpleName().identifierToken();
            List methodBody = method.block().body();
            methods.stream().skip((long)i + 1L).filter(otherMethodWithVariables -> !reported.contains(otherMethodWithVariables.method)).filter(otherMethodWithVariables -> !methodIdentifier.text().equals(otherMethodWithVariables.method.simpleName().name())).filter(otherMethodWithVariables -> SyntacticEquivalence.areEquivalent((List)methodBody, (List)otherMethodWithVariables.method.block().body())).filter(methodWithVariables::isUsingSameVariablesWithSameTypes).forEach(otherMethodWithVariables -> {
                MethodTree otherMethod = otherMethodWithVariables.method;
                this.reportIssue((Tree)otherMethod.simpleName(), String.format(ISSUE_MSG, methodIdentifier.text(), methodIdentifier.range().start().line()), Collections.singletonList(new JavaFileScannerContext.Location("original implementation", (Tree)methodIdentifier)), null);
                reported.add(otherMethod);
            });
        }
    }

    private static boolean isDuplicateCandidate(MethodTree methodTree, ClassTree classTree) {
        BlockTree block = methodTree.block();
        return AccessorsUtils.isAccessor((ClassTree)classTree, (MethodTree)methodTree) || block != null && block.body().size() >= 2;
    }

    private static class MethodWithUsedVariables
    extends BaseTreeVisitor {
        private final MethodTree method;
        private final Map<String, Type> usedVariablesByNameAndType = new HashMap<String, Type>();
        private boolean hasUnknownVariableType = false;

        public MethodWithUsedVariables(MethodTree method) {
            this.method = method;
            method.accept((TreeVisitor)this);
        }

        public boolean isUsingSameVariablesWithSameTypes(MethodWithUsedVariables otherMethod) {
            return !this.hasUnknownVariableType && !otherMethod.hasUnknownVariableType && this.usedVariablesByNameAndType.equals(otherMethod.usedVariablesByNameAndType);
        }

        public void visitIdentifier(IdentifierTree tree) {
            Symbol symbol = tree.symbol();
            Type type = symbol.type();
            if (symbol.isVariableSymbol()) {
                if (type.isUnknown()) {
                    this.hasUnknownVariableType = true;
                } else {
                    this.usedVariablesByNameAndType.putIfAbsent(tree.name(), type);
                }
            }
            super.visitIdentifier(tree);
        }
    }
}

