/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2209")
public class StaticMembersAccessCheck
extends IssuableSubscriptionVisitor {
    private QuickFixHelper.ImportSupplier importSupplier;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.importSupplier = null;
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.importSupplier = null;
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        IdentifierTree memberSelectIdentifier = memberSelect.identifier();
        Symbol memberSelectSymbol = memberSelectIdentifier.symbol();
        if (memberSelectSymbol.isStatic()) {
            ExpressionTree selectExpression;
            ExpressionTree leftOperand = memberSelect.expression();
            Object object = selectExpression = leftOperand.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)leftOperand).identifier() : leftOperand;
            if (!selectExpression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || ((IdentifierTree)selectExpression).symbol().isVariableSymbol()) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)leftOperand).withMessage("Change this instance-reference to a static reference.").withQuickFix(() -> this.createQuickFixes(leftOperand, memberSelectSymbol.owner().type())).report();
            }
        }
    }

    private JavaQuickFix createQuickFixes(ExpressionTree leftOperand, Type type) {
        String leftOperandAsText = leftOperand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? "\"" + ((IdentifierTree)leftOperand).name() + "\"" : "the expression";
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix((String)String.format("Replace %s by \"%s\"", leftOperandAsText, type.name())).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)leftOperand, (String)type.name())});
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        this.importSupplier.newImportEdit(type.fullyQualifiedName()).ifPresent(xva$0 -> builder.addTextEdit(new JavaTextEdit[]{xva$0}));
        return builder.build();
    }
}

