/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.math.BigInteger;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2129")
public class StringPrimitiveConstructorCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final BigInteger MIN_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MAX_VALUE);

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{STRING}).constructor().addWithoutParametersMatcher().addParametersMatcher(new String[]{STRING}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Byte"}).constructor().addParametersMatcher(new String[]{"byte"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Character"}).constructor().addParametersMatcher(new String[]{"char"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Short"}).constructor().addParametersMatcher(new String[]{"short"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Integer"}).constructor().addParametersMatcher(new String[]{"int"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Long"}).constructor().addParametersMatcher(new String[]{"long"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Float"}).constructor().addParametersMatcher(new String[]{"float"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Double"}).constructor().addParametersMatcher(new String[]{"double"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.lang.Boolean"}).constructor().addParametersMatcher(new String[]{"boolean"}).build(), MethodMatchers.create().ofTypes(new String[]{"java.math.BigInteger"}).constructor().addParametersMatcher(new String[]{STRING}).build()});
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (newClassTree.classBody() != null) {
            return;
        }
        if (StringPrimitiveConstructorCheck.isBigIntegerPotentiallyBiggerThanLong(newClassTree)) {
            return;
        }
        this.reportIssue((Tree)newClassTree.identifier(), "Remove this \"" + newClassTree.symbolType().name() + "\" constructor");
    }

    private static boolean isBigIntegerPotentiallyBiggerThanLong(NewClassTree newClassTree) {
        if (!newClassTree.symbolType().is("java.math.BigInteger")) {
            return false;
        }
        ExpressionTree argument = (ExpressionTree)newClassTree.arguments().get(0);
        if (!argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return true;
        }
        try {
            BigInteger value = new BigInteger(LiteralUtils.trimQuotes((String)((LiteralTree)argument).value()));
            return value.compareTo(MIN_BIG_INTEGER_VALUE) < 0 || value.compareTo(MAX_BIG_INTEGER_VALUE) > 0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

