/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import javax.annotation.Nullable;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.NewClassTree;

public abstract class AbstractAssertionVisitor
extends BaseTreeVisitor {
    private boolean hasAssertion = false;

    public void visitMethodInvocation(MethodInvocationTree mit) {
        super.visitMethodInvocation(mit);
        if (!this.hasAssertion && this.isAssertion(ExpressionUtils.methodName((MethodInvocationTree)mit), mit.symbol())) {
            this.hasAssertion = true;
        }
    }

    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        super.visitMethodReference(methodReferenceTree);
        if (!this.hasAssertion && this.isAssertion(methodReferenceTree.method(), methodReferenceTree.method().symbol())) {
            this.hasAssertion = true;
        }
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        if (!this.hasAssertion && this.isAssertion(null, tree.constructorSymbol())) {
            this.hasAssertion = true;
        }
    }

    public boolean hasAssertion() {
        return this.hasAssertion;
    }

    protected abstract boolean isAssertion(Symbol var1);

    private boolean isAssertion(@Nullable IdentifierTree method, Symbol methodSymbol) {
        return AbstractAssertionVisitor.matchesMethodPattern(method, methodSymbol) || UnitTestUtils.ASSERTION_INVOCATION_MATCHERS.matches(methodSymbol) || this.isAssertion(methodSymbol);
    }

    private static boolean matchesMethodPattern(@Nullable IdentifierTree method, Symbol methodSymbol) {
        if (method == null) {
            return false;
        }
        String methodName = method.name();
        if (UnitTestUtils.TEST_METHODS_PATTERN.matcher(methodName).matches()) {
            return !UnitTestUtils.REACTIVE_X_TEST_METHODS.matches(methodSymbol);
        }
        return UnitTestUtils.ASSERTION_METHODS_PATTERN.matcher(methodName).matches();
    }
}

