/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;

public class RegexReachabilityChecker {
    private static final int MAX_CACHE_SIZE = 5000;
    private final boolean defaultAnswer;
    private final Map<OrderedStatePair, Boolean> cache = new HashMap<OrderedStatePair, Boolean>();

    public RegexReachabilityChecker(boolean defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public boolean canReach(AutomatonState start, AutomatonState goal) {
        if (start == goal) {
            return true;
        }
        OrderedStatePair pair = new OrderedStatePair(start, goal);
        if (this.cache.containsKey(pair)) {
            return this.cache.get(pair);
        }
        if (this.cache.size() >= 5000) {
            return this.defaultAnswer;
        }
        this.cache.put(pair, false);
        boolean result = false;
        for (AutomatonState successor : start.successors()) {
            if (!this.canReach(successor, goal)) continue;
            result = true;
            break;
        }
        this.cache.put(pair, result);
        return result;
    }

    private static class OrderedStatePair {
        private final AutomatonState source;
        private final AutomatonState target;

        OrderedStatePair(AutomatonState source, AutomatonState target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OrderedStatePair)) {
                return false;
            }
            OrderedStatePair that = (OrderedStatePair)o;
            return this.source == that.source && this.target == that.target;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }
    }
}

