/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5868")
public class GraphemeClustersInClassesCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Extract %d Grapheme Cluster(s) from this character class.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new GraphemeInClassVisitor().visit(regexForLiterals);
    }

    private class GraphemeInClassVisitor
    extends RegexBaseVisitor {
        private final List<RegexCheck.RegexIssueLocation> graphemeClusters = new ArrayList<RegexCheck.RegexIssueLocation>();

        private GraphemeInClassVisitor() {
        }

        public void visitCharacterClass(CharacterClassTree tree) {
            super.visitCharacterClass(tree);
            if (!this.graphemeClusters.isEmpty()) {
                GraphemeClustersInClassesCheck.this.reportIssue((RegexSyntaxElement)tree, String.format(GraphemeClustersInClassesCheck.MESSAGE, this.graphemeClusters.size()), null, this.graphemeClusters);
            }
            this.graphemeClusters.clear();
        }

        public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
            this.graphemeClusters.addAll(RegexTreeHelper.getGraphemeInList(tree.getCharacterClasses()));
            super.visitCharacterClassUnion(tree);
        }
    }
}

