/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexReachabilityChecker;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;

@Rule(key="S5996")
public class ImpossibleBoundariesCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Remove or replace this boundary that will never match because it appears %s mandatory input.";
    private static final String SOFT_MESSAGE = "Remove or replace this boundary that can only match if the previous part matched the empty string because it appears %s mandatory input.";
    private final Set<RegexTree> excluded = new HashSet<RegexTree>();
    private final RegexReachabilityChecker regexReachabilityChecker = new RegexReachabilityChecker(false);

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new ImpossibleBoundaryFinder().visit(regexForLiterals);
    }

    private boolean canReachWithConsumingInput(AutomatonState start, AutomatonState goal, Set<AutomatonState> visited) {
        if (start == goal || visited.contains(start)) {
            return false;
        }
        visited.add(start);
        if (start instanceof LookAroundTree) {
            return this.canReachWithConsumingInput(start.continuation(), goal, visited);
        }
        for (AutomatonState successor : start.successors()) {
            AutomatonState.TransitionType transition = successor.incomingTransitionType();
            if ((transition != AutomatonState.TransitionType.CHARACTER || !this.regexReachabilityChecker.canReach(successor, goal)) && (transition == AutomatonState.TransitionType.CHARACTER || !this.canReachWithConsumingInput(successor, goal, visited))) continue;
            return true;
        }
        return false;
    }

    private class ImpossibleBoundaryFinder
    extends RegexBaseVisitor {
        private AutomatonState start;
        private AutomatonState end;

        private ImpossibleBoundaryFinder() {
        }

        public void visit(RegexParseResult regexParseResult) {
            ImpossibleBoundariesCheck.this.regexReachabilityChecker.clearCache();
            this.start = regexParseResult.getStartState();
            this.end = regexParseResult.getFinalState();
            super.visit(regexParseResult);
        }

        public void visitLookAround(LookAroundTree tree) {
            if (tree.getDirection() == LookAroundTree.Direction.BEHIND) {
                AutomatonState oldStart = this.start;
                this.start = tree.getElement();
                super.visitLookAround(tree);
                this.start = oldStart;
            } else {
                AutomatonState oldEnd = this.end;
                this.end = tree.getElement().continuation();
                super.visitLookAround(tree);
                this.end = oldEnd;
            }
        }

        public void visitDisjunction(DisjunctionTree tree) {
            BoundaryInDisjunctionFinder boundaryInDisjunctionFinder = new BoundaryInDisjunctionFinder();
            boundaryInDisjunctionFinder.visit((RegexTree)tree);
            ImpossibleBoundariesCheck.this.excluded.addAll(boundaryInDisjunctionFinder.foundBoundaries());
            super.visitDisjunction(tree);
        }

        public void visitBoundary(BoundaryTree boundaryTree) {
            switch (boundaryTree.type()) {
                case LINE_START: 
                case INPUT_START: {
                    if (!RegexTreeHelper.canReachWithoutConsumingInput(this.start, (AutomatonState)boundaryTree)) {
                        ImpossibleBoundariesCheck.this.reportIssue((RegexSyntaxElement)boundaryTree, String.format(ImpossibleBoundariesCheck.MESSAGE, "after"), null, Collections.emptyList());
                        break;
                    }
                    if (ImpossibleBoundariesCheck.this.excluded.contains(boundaryTree) || !this.probablyShouldConsumeInput(this.start, (AutomatonState)boundaryTree)) break;
                    ImpossibleBoundariesCheck.this.reportIssue((RegexSyntaxElement)boundaryTree, String.format(ImpossibleBoundariesCheck.SOFT_MESSAGE, "after"), null, Collections.emptyList());
                    break;
                }
                case LINE_END: 
                case INPUT_END: 
                case INPUT_END_FINAL_TERMINATOR: {
                    if (!RegexTreeHelper.canReachWithoutConsumingInput((AutomatonState)boundaryTree, this.end)) {
                        ImpossibleBoundariesCheck.this.reportIssue((RegexSyntaxElement)boundaryTree, String.format(ImpossibleBoundariesCheck.MESSAGE, "before"), null, Collections.emptyList());
                        break;
                    }
                    if (ImpossibleBoundariesCheck.this.excluded.contains(boundaryTree) || !this.probablyShouldConsumeInput((AutomatonState)boundaryTree, this.end)) break;
                    ImpossibleBoundariesCheck.this.reportIssue((RegexSyntaxElement)boundaryTree, String.format(ImpossibleBoundariesCheck.SOFT_MESSAGE, "before"), null, Collections.emptyList());
                    break;
                }
            }
        }

        private boolean probablyShouldConsumeInput(AutomatonState start, AutomatonState goal) {
            return ImpossibleBoundariesCheck.this.canReachWithConsumingInput(start, goal, new HashSet<AutomatonState>());
        }
    }

    private static class BoundaryInDisjunctionFinder
    extends RegexBaseVisitor {
        private final Set<BoundaryTree> foundBoundaries = new HashSet<BoundaryTree>();

        private BoundaryInDisjunctionFinder() {
        }

        public void visitBoundary(BoundaryTree boundaryTree) {
            this.foundBoundaries.add(boundaryTree);
        }

        public Set<BoundaryTree> foundBoundaries() {
            return new HashSet<BoundaryTree>(this.foundBoundaries);
        }
    }
}

