/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.helpers.SubAutomaton;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

@Rule(key="S5855")
public class RedundantRegexAlternativesCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new DisjunctionVisitor().visit(regexForLiterals);
    }

    private void reportRedundantIssue(RegexTree supersetAlternative, Set<RegexTree> redundantSubsetAlternatives) {
        ArrayList<RegexTree> redundantAlternatives = new ArrayList<RegexTree>(redundantSubsetAlternatives);
        redundantAlternatives.sort(Comparator.comparing(element -> element.getRange().getBeginningOffset()));
        RegexTree firstRedundantAlternatives = (RegexTree)redundantAlternatives.get(0);
        ArrayList<RegexCheck.RegexIssueLocation> secondaries = new ArrayList<RegexCheck.RegexIssueLocation>();
        secondaries.add(new RegexCheck.RegexIssueLocation((RegexSyntaxElement)supersetAlternative, "Alternative to keep"));
        redundantAlternatives.stream().skip(1L).map(otherRedundantAlternatives -> new RegexCheck.RegexIssueLocation((RegexSyntaxElement)otherRedundantAlternatives, "Other redundant alternative")).forEach(secondaries::add);
        this.reportIssue((RegexSyntaxElement)firstRedundantAlternatives, "Remove or rework this redundant alternative.", null, secondaries);
    }

    private class DisjunctionVisitor
    extends RegexBaseVisitor {
        private DisjunctionVisitor() {
        }

        public void visitDisjunction(DisjunctionTree tree) {
            RedundantAlternativeCollector collector = new RedundantAlternativeCollector();
            List alternatives = tree.getAlternatives();
            int i = 0;
            while (i + 1 < alternatives.size()) {
                for (int j = i + 1; j < alternatives.size(); ++j) {
                    collector.evaluate((RegexTree)alternatives.get(i), (RegexTree)alternatives.get(j));
                }
                ++i;
            }
            collector.supersetSubsetListMap.forEach((x$0, x$1) -> RedundantRegexAlternativesCheck.this.reportRedundantIssue((RegexTree)x$0, (Set<RegexTree>)x$1));
            super.visitDisjunction(tree);
        }
    }

    private static class CapturingGroupVisitor
    extends RegexBaseVisitor {
        boolean hasCapturingGroup;

        private CapturingGroupVisitor() {
        }

        public void visitCapturingGroup(CapturingGroupTree tree) {
            this.hasCapturingGroup = true;
        }
    }

    private static class RedundantAlternativeCollector {
        private final Map<RegexTree, Set<RegexTree>> supersetSubsetListMap = new LinkedHashMap<RegexTree, Set<RegexTree>>();
        private final Set<RegexTree> allSubsets = new HashSet<RegexTree>();

        private RedundantAlternativeCollector() {
        }

        private void evaluate(RegexTree prevAlternative, RegexTree nextAlternative) {
            if (RedundantAlternativeCollector.supersetOf(prevAlternative, nextAlternative)) {
                this.add(prevAlternative, nextAlternative);
            } else if (RedundantAlternativeCollector.supersetOf(nextAlternative, prevAlternative) && RedundantAlternativeCollector.hasNoCapturingGroup(prevAlternative) && RedundantAlternativeCollector.hasNoCapturingGroup(nextAlternative)) {
                this.add(nextAlternative, prevAlternative);
            }
        }

        private static boolean supersetOf(RegexTree alternative1, RegexTree alternative2) {
            SubAutomaton subAutomaton1 = new SubAutomaton((AutomatonState)alternative1, alternative1.continuation(), false);
            SubAutomaton subAutomaton2 = new SubAutomaton((AutomatonState)alternative2, alternative2.continuation(), false);
            return RegexTreeHelper.supersetOf(subAutomaton1, subAutomaton2, false);
        }

        private void add(RegexTree superset, RegexTree subset) {
            if (this.allSubsets.contains(subset)) {
                return;
            }
            if (this.allSubsets.contains(superset)) {
                return;
            }
            Set subsetList = this.supersetSubsetListMap.computeIfAbsent(superset, k -> new HashSet());
            Set<RegexTree> subsetOfTheSubset = this.supersetSubsetListMap.remove(subset);
            if (subsetOfTheSubset != null) {
                subsetList.addAll(subsetOfTheSubset);
            }
            this.allSubsets.add(subset);
            subsetList.add(subset);
        }

        private static boolean hasNoCapturingGroup(RegexTree tree) {
            CapturingGroupVisitor visitor = new CapturingGroupVisitor();
            tree.accept((RegexVisitor)visitor);
            return !visitor.hasCapturingGroup;
        }
    }
}

