/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.SimplifiedRegexCharacterClass;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;
import org.sonarsource.analyzer.commons.regex.ast.SimpleQuantifier;

@Rule(key="S5857")
public class ReluctantQuantifierCheck
extends AbstractRegexCheck {
    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation) {
        new ReluctantQuantifierFinder().visit(regexForLiterals);
    }

    private class ReluctantQuantifierFinder
    extends RegexBaseVisitor {
        private ReluctantQuantifierFinder() {
        }

        public void visitSequence(SequenceTree tree) {
            int repetitionPos;
            super.visitSequence(tree);
            List items = tree.getItems();
            for (repetitionPos = items.size() - 2; repetitionPos > 0 && ((RegexTree)items.get(repetitionPos)).is(new RegexTree.Kind[]{RegexTree.Kind.NON_CAPTURING_GROUP}) && ((NonCapturingGroupTree)items.get(repetitionPos)).getElement() == null; --repetitionPos) {
            }
            if (repetitionPos >= 0 && ((RegexTree)items.get(repetitionPos)).is(new RegexTree.Kind[]{RegexTree.Kind.REPETITION})) {
                RepetitionTree repetition = (RepetitionTree)items.get(repetitionPos);
                this.getReluctantlyQuantifiedElement(repetition).flatMap(element -> this.findNegatedCharacterClassFor((RegexTree)items.get(items.size() - 1), this.getBaseCharacter((RegexTree)element))).ifPresent(negatedClass -> {
                    String newQuantifier = this.makePossessive(repetition.getQuantifier());
                    String message = String.format("Replace this use of a reluctant quantifier with \"%s%s\".", negatedClass, newQuantifier);
                    ReluctantQuantifierCheck.this.reportIssue((RegexSyntaxElement)repetition, message, null, Collections.emptyList());
                });
            }
        }

        private Optional<RegexTree> getReluctantlyQuantifiedElement(RepetitionTree repetition) {
            RegexTree element = repetition.getElement();
            while (element.is(new RegexTree.Kind[]{RegexTree.Kind.NON_CAPTURING_GROUP})) {
                if ((element = ((NonCapturingGroupTree)element).getElement()) != null) continue;
                return Optional.empty();
            }
            return repetition.getQuantifier().getModifier() == Quantifier.Modifier.RELUCTANT && !repetition.getQuantifier().isFixed() && (element.is(new RegexTree.Kind[]{RegexTree.Kind.DOT}) || element.is(new RegexTree.Kind[]{RegexTree.Kind.ESCAPED_CHARACTER_CLASS})) ? Optional.of(element) : Optional.empty();
        }

        private String makePossessive(Quantifier quantifier) {
            if (quantifier instanceof SimpleQuantifier) {
                return ((SimpleQuantifier)quantifier).getKind() + "+";
            }
            String max = Optional.ofNullable(quantifier.getMaximumRepetitions()).map(Object::toString).orElse("");
            return String.format("{%d,%s}+", quantifier.getMinimumRepetitions(), max);
        }

        private Optional<String> findNegatedCharacterClassFor(RegexTree tree, @Nullable EscapedCharacterClassTree base) {
            Object result;
            if (tree instanceof CharacterClassElementTree && this.hasNoIntersection((CharacterClassElementTree)tree, (CharacterClassElementTree)base)) {
                return Optional.empty();
            }
            switch (tree.kind()) {
                case CHARACTER: {
                    result = "[^" + tree.getText() + this.negateEscapedCharacter(base) + "]";
                    break;
                }
                case ESCAPED_CHARACTER_CLASS: {
                    EscapedCharacterClassTree escapedClass = (EscapedCharacterClassTree)tree;
                    result = this.escapedCharacterFollowedByEscapedCharacter(escapedClass, this.negateEscapedCharacter(base));
                    break;
                }
                case CHARACTER_CLASS: {
                    CharacterClassTree characterClass = (CharacterClassTree)tree;
                    String body = characterClass.getContents().getText();
                    if (characterClass.isNegated()) {
                        result = "[" + body + this.escapedCharacterToString(base) + "]";
                        break;
                    }
                    result = "[^" + body + this.negateEscapedCharacter(base) + "]";
                    break;
                }
                case NON_CAPTURING_GROUP: {
                    RegexTree element = ((NonCapturingGroupTree)tree).getElement();
                    return element == null ? Optional.empty() : this.findNegatedCharacterClassFor(element, base);
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(result);
        }

        @Nullable
        private EscapedCharacterClassTree getBaseCharacter(RegexTree tree) {
            return tree.is(new RegexTree.Kind[]{RegexTree.Kind.DOT}) ? null : (EscapedCharacterClassTree)tree;
        }

        private boolean hasNoIntersection(CharacterClassElementTree tree, @Nullable CharacterClassElementTree base) {
            if (base == null) {
                return false;
            }
            SimplifiedRegexCharacterClass baseSimplifiedCharacterClass = new SimplifiedRegexCharacterClass(base);
            SimplifiedRegexCharacterClass treeSimplifiedCharacterClass = new SimplifiedRegexCharacterClass(tree);
            return !baseSimplifiedCharacterClass.intersects(treeSimplifiedCharacterClass, false);
        }

        private String escapedCharacterFollowedByEscapedCharacter(EscapedCharacterClassTree escapedClass, String ignoredSymbol) {
            String negatedCharacter = "\\\\" + this.negateEscapedCharacterClassType(escapedClass.getType()) + this.getProperty(escapedClass);
            return ignoredSymbol.isEmpty() ? negatedCharacter : String.format("[%s%s]", negatedCharacter, ignoredSymbol);
        }

        private String getProperty(EscapedCharacterClassTree escapedClass) {
            return escapedClass.isProperty() ? "{" + escapedClass.property() + "}" : "";
        }

        private char negateEscapedCharacterClassType(char type) {
            return Character.isLowerCase(type) ? Character.toUpperCase(type) : Character.toLowerCase(type);
        }

        private String negateEscapedCharacter(@Nullable EscapedCharacterClassTree escapedClass) {
            return escapedClass == null ? "" : this.escapedCharacterFollowedByEscapedCharacter(escapedClass, "");
        }

        private String escapedCharacterToString(@Nullable EscapedCharacterClassTree escapedClass) {
            return escapedClass == null ? "" : "\\\\" + escapedClass.getType() + this.getProperty(escapedClass);
        }
    }
}

