/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2057")
public class SerialVersionUidCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        this.visitClassTree((ClassTree)tree);
    }

    private void visitClassTree(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null && SerialVersionUidCheck.isSerializable(symbol.type())) {
            Symbol.VariableSymbol serialVersionUidSymbol = SerialVersionUidCheck.findSerialVersionUid(symbol);
            if (serialVersionUidSymbol == null) {
                if (!SerialVersionUidCheck.isExclusion(symbol)) {
                    this.reportIssue((Tree)simpleName, "Add a \"static final long serialVersionUID\" field to this class.");
                }
            } else {
                this.checkModifiers(serialVersionUidSymbol);
            }
        }
    }

    private void checkModifiers(Symbol.VariableSymbol serialVersionUidSymbol) {
        VariableTree variableTree;
        ArrayList<String> missingModifiers = new ArrayList<String>();
        if (!serialVersionUidSymbol.isStatic()) {
            missingModifiers.add("static");
        }
        if (!serialVersionUidSymbol.isFinal()) {
            missingModifiers.add("final");
        }
        if (!serialVersionUidSymbol.type().is("long")) {
            missingModifiers.add("long");
        }
        if ((variableTree = serialVersionUidSymbol.declaration()) != null && !missingModifiers.isEmpty()) {
            this.reportIssue((Tree)variableTree.simpleName(), "Make this \"serialVersionUID\" field \"" + String.join((CharSequence)" ", missingModifiers) + "\".");
        }
    }

    private static Symbol.VariableSymbol findSerialVersionUid(Symbol.TypeSymbol symbol) {
        for (Symbol member : symbol.lookupSymbols("serialVersionUID")) {
            if (!member.isVariableSymbol()) continue;
            return (Symbol.VariableSymbol)member;
        }
        return null;
    }

    private static boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean isExclusion(Symbol.TypeSymbol symbol) {
        return symbol.isAbstract() || symbol.type().isSubtypeOf("java.lang.Throwable") || SerialVersionUidCheck.isGuiClass(symbol);
    }

    private static boolean isGuiClass(Symbol.TypeSymbol symbol) {
        for (Type superType : JUtils.superTypes((Symbol.TypeSymbol)symbol)) {
            Symbol.TypeSymbol superTypeSymbol = superType.symbol();
            if (!SerialVersionUidCheck.hasGuiPackage(superTypeSymbol)) continue;
            return true;
        }
        return SerialVersionUidCheck.hasGuiPackage(symbol) || !symbol.equals(JUtils.outermostClass((Symbol.TypeSymbol)symbol)) && SerialVersionUidCheck.isGuiClass(JUtils.outermostClass((Symbol.TypeSymbol)symbol));
    }

    private static boolean hasGuiPackage(Symbol.TypeSymbol superTypeSymbol) {
        String fullyQualifiedName = superTypeSymbol.type().fullyQualifiedName();
        return fullyQualifiedName.startsWith("javax.swing.") || fullyQualifiedName.startsWith("java.awt.");
    }
}

