/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.tests.AbstractMockitoArgumentChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S6073")
public class MockitoArgumentMatchersUsedOnAllParametersCheck
extends AbstractMockitoArgumentChecker {
    private static final String ARGUMENT_CAPTOR_CLASS = "org.mockito.ArgumentCaptor";
    private static final String ARGUMENT_MATCHER_CLASS = "org.mockito.ArgumentMatchers";
    private static final String ADDITIONAL_MATCHER_CLASS = "org.mockito.AdditionalMatchers";
    private static final String OLD_MATCHER_CLASS = "org.mockito.Matchers";
    private static final String TOP_MOCKITO_CLASS = "org.mockito.Mockito";
    private static final MethodMatchers ARGUMENT_MARCHER = MethodMatchers.create().ofTypes(new String[]{"org.mockito.ArgumentMatchers", "org.mockito.AdditionalMatchers", "org.mockito.Matchers", "org.mockito.Mockito"}).anyName().withAnyParameters().build();
    private static final MethodMatchers ARGUMENT_CAPTOR = MethodMatchers.create().ofTypes(new String[]{"org.mockito.ArgumentCaptor"}).names(new String[]{"capture"}).addWithoutParametersMatcher().build();

    public void leaveFile(JavaFileScannerContext context) {
        MethodVisitor.cachedResults.clear();
    }

    @Override
    protected void visitArguments(Arguments arguments) {
        if (arguments.isEmpty()) {
            return;
        }
        ArrayList<ExpressionTree> nonMatchers = new ArrayList<ExpressionTree>();
        for (ExpressionTree arg : arguments) {
            if (MockitoArgumentMatchersUsedOnAllParametersCheck.isArgumentMatcherLike(arg = ExpressionUtils.skipParentheses((ExpressionTree)arg))) continue;
            nonMatchers.add(arg);
        }
        int nonMatchersFound = nonMatchers.size();
        if (!nonMatchers.isEmpty() && nonMatchersFound < arguments.size()) {
            String primaryMessage = String.format("Add an \"eq()\" argument matcher on %s", nonMatchersFound == 1 ? "this parameter." : "these parameters.");
            this.reportIssue((Tree)nonMatchers.get(0), primaryMessage, nonMatchers.stream().skip(1L).map(secondary -> new JavaFileScannerContext.Location("", secondary)).collect(Collectors.toList()), null);
        }
    }

    private static boolean isArgumentMatcherLike(ExpressionTree tree) {
        ExpressionTree unpacked = MockitoArgumentMatchersUsedOnAllParametersCheck.skipCasts(tree);
        if (!unpacked.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)unpacked;
        return ARGUMENT_CAPTOR.matches(invocation) || ARGUMENT_MARCHER.matches(invocation) || MockitoArgumentMatchersUsedOnAllParametersCheck.returnsAnArgumentMatcher(invocation);
    }

    private static boolean returnsAnArgumentMatcher(MethodInvocationTree invocation) {
        ExpressionTree methodSelect = invocation.methodSelect();
        IdentifierTree identifier = null;
        identifier = methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)methodSelect).identifier() : (IdentifierTree)methodSelect;
        Symbol symbol = identifier.symbol();
        if (symbol.isUnknown()) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        MethodTree declaration = methodSymbol.declaration();
        if (declaration == null) {
            return false;
        }
        MethodVisitor methodVisitor = new MethodVisitor();
        declaration.accept((TreeVisitor)methodVisitor);
        return methodVisitor.onlyReturnsMethodInvocations;
    }

    private static ExpressionTree skipCasts(ExpressionTree tree) {
        ExpressionTree current = ExpressionUtils.skipParentheses((ExpressionTree)tree);
        while (current.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            TypeCastTree cast = (TypeCastTree)current;
            current = ExpressionUtils.skipParentheses((ExpressionTree)cast.expression());
        }
        return current;
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        static Map<MethodTree, Boolean> cachedResults = new HashMap<MethodTree, Boolean>();
        boolean onlyReturnsMethodInvocations = false;

        private MethodVisitor() {
        }

        public void visitMethod(MethodTree tree) {
            if (cachedResults.containsKey(tree)) {
                this.onlyReturnsMethodInvocations = cachedResults.get(tree);
                return;
            }
            cachedResults.put(tree, Boolean.FALSE);
            BlockTree block = tree.block();
            if (block == null) {
                cachedResults.put(tree, Boolean.TRUE);
                return;
            }
            this.onlyReturnsMethodInvocations = block.body().stream().filter(statement -> statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})).map(ReturnStatementTree.class::cast).map(ReturnStatementTree::expression).allMatch(expression -> expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}));
            cachedResults.put(tree, this.onlyReturnsMethodInvocations);
        }
    }
}

