/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.java.checks.AbstractClassNoFieldShouldBeInterfaceCheck;
import org.sonar.java.checks.EqualsNotOverridenWithCompareToCheck;
import org.sonar.java.checks.EqualsOverridenWithHashCodeCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.SetUtils;

public class GoogleAutoFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = SetUtils.immutableSetOf((Object[])new Class[]{EqualsOverridenWithHashCodeCheck.class, EqualsNotOverridenWithCompareToCheck.class, AbstractClassNoFieldShouldBeInterfaceCheck.class});
    private static final String AUTO_VALUE_ANNOTATION = "com.google.auto.value.AutoValue";
    private static final List<String> AUTO_ANNOTATIONS = Arrays.asList("com.google.auto.value.AutoValue$Builder", "com.google.auto.value.AutoOneOf");

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    public void visitClass(ClassTree tree) {
        block5: {
            block4: {
                SymbolMetadata classMetadata = tree.symbol().metadata();
                boolean isAnnotatedWithAutoValue = classMetadata.isAnnotatedWith(AUTO_VALUE_ANNOTATION);
                if (isAnnotatedWithAutoValue) {
                    this.excludeLines((Tree)tree, EqualsOverridenWithHashCodeCheck.class);
                    this.excludeLines((Tree)tree, EqualsNotOverridenWithCompareToCheck.class);
                }
                if (isAnnotatedWithAutoValue) break block4;
                if (!AUTO_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)classMetadata).isAnnotatedWith(arg_0))) break block5;
            }
            this.excludeLines((Tree)tree.simpleName(), AbstractClassNoFieldShouldBeInterfaceCheck.class);
        }
        super.visitClass(tree);
    }
}

