/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractAccessibilityChangeChecker;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6216")
public class AccessibilityChangeOnRecordsCheck
extends AbstractAccessibilityChangeChecker {
    private static final String MESSAGE = "Remove this private field update which will never succeed";
    private static final String SECONDARY_MESSAGE = "Remove this accessibility bypass which will never succeed";
    private Map<Symbol, MethodInvocationTree> primaryTargets = new HashMap<Symbol, MethodInvocationTree>();
    private Map<Symbol, List<MethodInvocationTree>> secondaryTargets = new HashMap<Symbol, List<MethodInvocationTree>>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            this.primaryTargets.clear();
            this.secondaryTargets.clear();
        }
        super.visitNode(tree);
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT})) {
            for (Map.Entry<Symbol, MethodInvocationTree> entry : this.primaryTargets.entrySet()) {
                Symbol symbol = entry.getKey();
                MethodInvocationTree setInvocation = entry.getValue();
                List<JavaFileScannerContext.Location> secondaries = this.secondaryTargets.getOrDefault(symbol, Collections.emptyList()).stream().map(mit -> new JavaFileScannerContext.Location(SECONDARY_MESSAGE, (Tree)mit)).toList();
                this.reportIssue((Tree)setInvocation, MESSAGE, secondaries, null);
            }
        }
        super.leaveNode(tree);
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!AccessibilityChangeOnRecordsCheck.isModifyingFieldFromRecord(mit)) {
            return;
        }
        if (SET_MATCHERS.matches(mit)) {
            Optional<Symbol> symbol = AccessibilityChangeOnRecordsCheck.getIdentifierSymbol(mit);
            if (symbol.isPresent()) {
                this.primaryTargets.put(symbol.get(), mit);
            } else {
                this.reportIssue((Tree)mit, MESSAGE);
            }
        } else if (AccessibilityChangeOnRecordsCheck.setsToPubliclyAccessible(mit)) {
            Optional<Symbol> symbol = AccessibilityChangeOnRecordsCheck.getIdentifierSymbol(mit);
            symbol.ifPresent(key -> {
                List secondaries = this.secondaryTargets.getOrDefault(key, new ArrayList());
                secondaries.add(mit);
                this.secondaryTargets.put((Symbol)key, secondaries);
            });
        }
    }

    private static Optional<Symbol> getIdentifierSymbol(MethodInvocationTree mit) {
        ExpressionTree expression = mit.methodSelect();
        if (!expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return Optional.empty();
        }
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expression;
        ExpressionTree callee = memberSelect.expression();
        if (!callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return Optional.empty();
        }
        IdentifierTree identifier = (IdentifierTree)callee;
        return Optional.of(identifier.symbol());
    }
}

