/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.ConfusingOverloadCheck;
import org.sonar.java.checks.helpers.AnnotationsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3242")
public class LeastSpecificTypeCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SPRING_INJECT_ANNOTATIONS = Set.of("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject", "jakarta.inject.Inject", "javax.annotation.Resource", "jakarta.annotation.Resource");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        SymbolMetadata metadata = methodSymbol.metadata();
        if (!methodSymbol.isPublic() || !Boolean.FALSE.equals(methodTree.isOverriding()) || LeastSpecificTypeCheck.isOverloaded(methodSymbol) || AnnotationsHelper.hasUnknownAnnotation(metadata)) {
            return;
        }
        boolean springInjectionAnnotated = LeastSpecificTypeCheck.isSpringInjectionAnnotated(metadata);
        methodTree.parameters().stream().map(VariableTree::symbol).filter(p -> p.type().isClass() && !p.type().symbol().isEnum() && !LeastSpecificTypeCheck.isStringType(p.type())).filter(p -> !springInjectionAnnotated || !p.type().is("java.util.Collection")).forEach(p -> this.handleParameter((Symbol)p, springInjectionAnnotated));
    }

    private static boolean isOverloaded(Symbol.MethodSymbol methodSymbol) {
        return ((Symbol.TypeSymbol)methodSymbol.owner()).lookupSymbols(methodSymbol.name()).size() > 1;
    }

    private static boolean isStringType(Type type) {
        return type.isUnknown() || type.is("java.lang.String");
    }

    private void handleParameter(Symbol parameter, boolean springInjectionAnnotated) {
        Type parameterType = parameter.type();
        if (parameterType.symbol().metadata().isAnnotatedWith("java.lang.FunctionalInterface")) {
            return;
        }
        Type leastSpecificType = LeastSpecificTypeCheck.findLeastSpecificType(parameter);
        if (parameterType != leastSpecificType && !leastSpecificType.is("java.lang.Object")) {
            String suggestedType = LeastSpecificTypeCheck.getSuggestedType(springInjectionAnnotated, leastSpecificType);
            String message = String.format("Use '%s' here; it is a more general type than '%s'.", suggestedType, parameterType.erasure().name());
            this.reportIssue(parameter.declaration(), message);
        }
    }

    private static String getSuggestedType(boolean springInjectionAnnotated, Type leastSpecificType) {
        if (springInjectionAnnotated && leastSpecificType.is("java.lang.Iterable")) {
            return "java.util.Collection";
        }
        return leastSpecificType.fullyQualifiedName().replace('$', '.');
    }

    private static Type findLeastSpecificType(Symbol parameter) {
        InheritanceGraph inheritanceGraph = new InheritanceGraph(parameter.type());
        for (IdentifierTree usage : parameter.usages()) {
            MethodInvocationTree mit;
            Tree parent;
            for (parent = usage.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS, Tree.Kind.METHOD_INVOCATION, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT}); parent = parent.parent()) {
            }
            if (parent == null || parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ARGUMENTS})) {
                return parameter.type();
            }
            if (parent.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
                LeastSpecificTypeCheck.findIteratorMethod(parameter).ifPresent(inheritanceGraph::update);
                continue;
            }
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || !LeastSpecificTypeCheck.isMethodInvocationOnParameter(parameter, mit = (MethodInvocationTree)parent)) continue;
            inheritanceGraph.update(mit.methodSymbol());
        }
        return inheritanceGraph.leastSpecificType();
    }

    private static Optional<Symbol.MethodSymbol> findIteratorMethod(Symbol parameter) {
        return parameter.type().symbol().lookupSymbols("iterator").stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(methodSymbol -> methodSymbol.parameterTypes().isEmpty()).findFirst();
    }

    private static boolean isMethodInvocationOnParameter(Symbol parameter, MethodInvocationTree mit) {
        MemberSelectExpressionTree mset;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mset = (MemberSelectExpressionTree)mit.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)mset.expression()).symbol();
            return symbol == parameter;
        }
        return false;
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return SPRING_INJECT_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }

    private static class InheritanceGraph {
        private final Type startType;
        private List<List<Type>> chains = null;

        private InheritanceGraph(Type type) {
            this.startType = type;
        }

        private void update(Symbol.MethodSymbol m) {
            if (this.chains == null) {
                this.chains = this.computeChains(m, this.startType);
            } else {
                this.refineChains(m);
            }
        }

        private List<List<Type>> computeChains(Symbol.MethodSymbol m, Type type) {
            boolean isSpecialization;
            ArrayList<List<Type>> result = new ArrayList<List<Type>>();
            Symbol.TypeSymbol typeSymbol = type.symbol();
            Type superClass = typeSymbol.superClass();
            if (superClass != null) {
                this.computeChainsForSuperType(result, m, type, superClass);
            }
            for (Type i : typeSymbol.interfaces()) {
                this.computeChainsForSuperType(result, m, type, i);
            }
            boolean definesSymbol = InheritanceGraph.definesSymbol(m, typeSymbol);
            boolean bl = isSpecialization = !this.startType.isParameterized() && type.isParameterized();
            if (definesSymbol && !isSpecialization && result.isEmpty()) {
                ArrayList<Type> list = new ArrayList<Type>();
                list.add(type);
                result.add(list);
            }
            return result;
        }

        private void computeChainsForSuperType(List<List<Type>> result, Symbol.MethodSymbol methodSymbol, Type type, Type superType) {
            for (List<Type> chain : this.computeChains(methodSymbol, superType)) {
                chain.add(type);
                result.add(chain);
            }
        }

        private static boolean definesOrInheritsSymbol(Symbol.MethodSymbol methodSymbol, Symbol.TypeSymbol typeSymbol) {
            return InheritanceGraph.definesSymbol(methodSymbol, typeSymbol) || typeSymbol.superTypes().stream().anyMatch(superType -> InheritanceGraph.definesSymbol(methodSymbol, superType.symbol()));
        }

        private static boolean definesSymbol(Symbol.MethodSymbol methodSymbol, Symbol.TypeSymbol typeSymbol) {
            return typeSymbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast).filter(memberMethodSymbol -> memberMethodSymbol.name().equals(methodSymbol.name())).anyMatch(memberMethodSymbol -> InheritanceGraph.isOverridingWithSameReturnType(methodSymbol, memberMethodSymbol));
        }

        private void refineChains(Symbol.MethodSymbol m) {
            for (List<Type> chain : this.chains) {
                Type type;
                Iterator<Type> chainIterator = chain.iterator();
                while (chainIterator.hasNext() && !InheritanceGraph.definesOrInheritsSymbol(m, (type = chainIterator.next()).symbol())) {
                    chainIterator.remove();
                }
            }
        }

        private Type leastSpecificType() {
            if (this.chains == null) {
                return this.startType;
            }
            this.chains.forEach(c -> c.removeIf(t -> !t.symbol().isPublic()));
            if (this.chains.stream().allMatch(List::isEmpty)) {
                return this.startType;
            }
            this.chains.sort(Comparator.comparingInt(List::size).thenComparing(chain -> ((Type)chain.get(0)).symbol().isInterface(), Boolean::compare).thenComparing(chain -> (Type)chain.get(0), Comparator.comparing(Type::fullyQualifiedName).reversed()).reversed());
            List<Type> longestChain = this.chains.get(0);
            return longestChain.get(0);
        }

        private static boolean isOverridingWithSameReturnType(Symbol.MethodSymbol m, Symbol.MethodSymbol leastSpecificM) {
            return (m.returnType().type() == leastSpecificM.returnType().type() || InheritanceGraph.isGenericReturnType(leastSpecificM)) && ConfusingOverloadCheck.isPotentialOverride(m, leastSpecificM);
        }

        private static boolean isGenericReturnType(Symbol.MethodSymbol leastSpecificM) {
            return InheritanceGraph.isGenericType(leastSpecificM.returnType().type());
        }

        private static boolean isGenericType(Type type) {
            return type.isTypeVar() || type.isParameterized() && type.typeArguments().stream().allMatch(InheritanceGraph::isGenericType);
        }
    }
}

