/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.LineUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1659")
public class OneDeclarationPerLineCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern INDENTATION_PATTERN = Pattern.compile("^(\\s+)");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.INTERFACE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.CASE_GROUP);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE})) {
            this.checkVariables(((ClassTree)tree).members());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER})) {
            this.checkVariables(((BlockTree)tree).body());
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.checkVariables(((CaseGroupTree)tree).body());
        }
    }

    private void checkVariables(List<? extends Tree> trees) {
        boolean varSameDeclaration = false;
        int lastVarLine = -1;
        ArrayList<VariableTree> nodesToReport = new ArrayList<VariableTree>();
        for (Tree tree : trees) {
            if (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            VariableTree varTree = (VariableTree)tree;
            int line = LineUtils.startLine((SyntaxToken)varTree.simpleName().identifierToken());
            if (varSameDeclaration || lastVarLine == line) {
                nodesToReport.add(varTree);
            } else {
                this.reportIfIssue(nodesToReport);
            }
            varSameDeclaration = ",".equals(varTree.endToken().text());
            lastVarLine = line;
        }
        this.reportIfIssue(nodesToReport);
    }

    private void reportIfIssue(List<VariableTree> nodesToReport) {
        if (!nodesToReport.isEmpty()) {
            IdentifierTree firstLocation = nodesToReport.get(0).simpleName();
            String moreThanOneMessage = nodesToReport.size() > 1 ? " and all following declarations" : "";
            QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)firstLocation).withMessage("Declare \"%s\"%s on a separate line.", new Object[]{firstLocation.name(), moreThanOneMessage}).withSecondaries(nodesToReport.stream().skip(1L).map(lit -> new JavaFileScannerContext.Location("", (Tree)lit.simpleName())).toList()).withQuickFix(() -> this.getQuickFixes(nodesToReport)).report();
            nodesToReport.clear();
        }
    }

    private JavaQuickFix getQuickFixes(List<VariableTree> nodesToReport) {
        ArrayList<JavaTextEdit> edits = new ArrayList<JavaTextEdit>();
        SyntaxToken previousToken = QuickFixHelper.previousToken((Tree)nodesToReport.get(0));
        for (VariableTree variableTree : nodesToReport) {
            String indentationOfLine = this.indentationOfLine((Tree)variableTree);
            edits.add(this.getEditForVariable(variableTree, previousToken, indentationOfLine));
            previousToken = variableTree.lastToken();
        }
        return JavaQuickFix.newQuickFix((String)"Declare on separated lines").addTextEdits(edits).build();
    }

    private JavaTextEdit getEditForVariable(VariableTree variableTree, SyntaxToken previousToken, String indentationOfLine) {
        if (",".equals(previousToken.text())) {
            return JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)previousToken, (boolean)true, (Tree)variableTree.simpleName(), (boolean)false), (String)String.format(";\n%s%s ", indentationOfLine, this.modifiersAndType(variableTree)));
        }
        return JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)AnalyzerMessage.textSpanBetween((Tree)previousToken, (boolean)false, (Tree)variableTree, (boolean)false), (String)String.format("\n%s", indentationOfLine));
    }

    private String modifiersAndType(VariableTree variableTree) {
        ModifiersTree modifiers = variableTree.modifiers();
        if (modifiers.isEmpty()) {
            return QuickFixHelper.contentForTree((Tree)variableTree.type(), this.context);
        }
        return QuickFixHelper.contentForRange(variableTree.modifiers().firstToken(), variableTree.type().lastToken(), this.context);
    }

    private String indentationOfLine(Tree tree) {
        Matcher matcher = INDENTATION_PATTERN.matcher((CharSequence)this.context.getFileLines().get(LineUtils.startLine((Tree)tree) - 1));
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }
}

