/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.PatternInstanceOfTree;
import org.sonar.plugins.java.api.tree.PatternTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6880")
public class PatternMatchUsingIfCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String ISSUE_MESSAGE = "Replace the chain of if/else with a switch expression.";
    private static final int INDENT = 2;
    private static final Set<String> SCRUTINEE_TYPES_FOR_NON_PATTERN_SWITCH = Set.of("byte", "short", "char", "int", "java.lang.Byte", "java.lang.Short", "java.lang.Character", "java.lang.Integer");

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree topLevelIfStat = (IfStatementTree)tree;
        if (PatternMatchUsingIfCheck.isElseIf(topLevelIfStat) || !PatternMatchUsingIfCheck.hasElseIf(topLevelIfStat)) {
            return;
        }
        if (!topLevelIfStat.condition().is(new Tree.Kind[]{Tree.Kind.PATTERN_INSTANCE_OF, Tree.Kind.EQUAL_TO, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR})) {
            return;
        }
        List<Case> cases = PatternMatchUsingIfCheck.extractCasesFromIfSequence(topLevelIfStat);
        if (cases == null || !(cases.get(cases.size() - 1) instanceof DefaultCase) || !PatternMatchUsingIfCheck.casesHaveCommonScrutinee(cases) || cases.get(0) instanceof EqualityCase && !PatternMatchUsingIfCheck.hasValidScrutineeTypeForNonPatternSwitch(cases.get(0).scrutinee())) {
            return;
        }
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)topLevelIfStat.ifKeyword()).withMessage(ISSUE_MESSAGE).withQuickFix(() -> this.computeQuickFix(cases, topLevelIfStat)).report();
    }

    private static boolean casesHaveCommonScrutinee(List<Case> cases) {
        return cases.stream().allMatch(c -> c.scrutinee().name().equals(((Case)cases.get(0)).scrutinee().name()));
    }

    private static boolean hasValidScrutineeTypeForNonPatternSwitch(IdentifierTree scrutinee) {
        if (scrutinee.symbolType().symbol().isEnum()) {
            return true;
        }
        String fullyQualifiedTypeName = scrutinee.symbolType().fullyQualifiedName();
        return SCRUTINEE_TYPES_FOR_NON_PATTERN_SWITCH.contains(fullyQualifiedTypeName);
    }

    @Nullable
    private static List<Case> extractCasesFromIfSequence(IfStatementTree topLevelIfStat) {
        LinkedList<Case> cases = new LinkedList<Case>();
        IfStatementTree stat = topLevelIfStat;
        while (stat instanceof IfStatementTree) {
            IfStatementTree ifStat = stat;
            Case caze = PatternMatchUsingIfCheck.convertToCase(ifStat.condition(), ifStat.thenStatement());
            if (caze == null) {
                return null;
            }
            cases.add(caze);
            stat = ifStat.elseStatement();
        }
        if (stat != null) {
            cases.add(new DefaultCase(cases.getLast().scrutinee(), (StatementTree)stat));
        }
        return cases;
    }

    @Nullable
    private static Case convertToCase(ExpressionTree condition, StatementTree body) {
        ExpressionTree expressionTree;
        PatternInstanceOfTree patInstOf;
        ExpressionTree leftmost = PatternMatchUsingIfCheck.findLeftmostInConjunction(condition);
        LinkedList<ExpressionTree> guards = new LinkedList<ExpressionTree>();
        PatternMatchUsingIfCheck.populateGuardsList(condition, guards);
        if (leftmost instanceof PatternInstanceOfTree && (patInstOf = (PatternInstanceOfTree)leftmost).pattern() != null && (expressionTree = patInstOf.expression()) instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)expressionTree;
            return new PatternMatchCase(idTree, patInstOf.pattern(), guards, body);
        }
        if ((leftmost.kind() == Tree.Kind.CONDITIONAL_OR || leftmost.kind() == Tree.Kind.EQUAL_TO) && guards.isEmpty()) {
            return PatternMatchUsingIfCheck.buildEqualityCase(leftmost, body);
        }
        return null;
    }

    @Nullable
    private static EqualityCase buildEqualityCase(ExpressionTree expr, StatementTree body) {
        LinkedList<ExpressionTree> constantsList = new LinkedList<ExpressionTree>();
        IdentifierTree scrutinee = null;
        while (expr.kind() == Tree.Kind.CONDITIONAL_OR) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expr;
            Pair<IdentifierTree, ExpressionTree> varAndCst = PatternMatchUsingIfCheck.extractVarAndConstFromEqualityCheck(binary.rightOperand());
            if (varAndCst == null) {
                return null;
            }
            if (scrutinee == null) {
                scrutinee = (IdentifierTree)varAndCst.a;
            } else if (!((IdentifierTree)varAndCst.a).name().equals(scrutinee.name())) {
                return null;
            }
            constantsList.addFirst((ExpressionTree)varAndCst.b);
            expr = binary.leftOperand();
        }
        Pair<IdentifierTree, ExpressionTree> varAndCst = PatternMatchUsingIfCheck.extractVarAndConstFromEqualityCheck(expr);
        if (varAndCst == null || scrutinee != null && !((IdentifierTree)varAndCst.a).name().equals(scrutinee.name())) {
            return null;
        }
        constantsList.addFirst((ExpressionTree)varAndCst.b);
        return new EqualityCase(scrutinee == null ? (IdentifierTree)varAndCst.a : scrutinee, constantsList, body);
    }

    @Nullable
    private static Pair<IdentifierTree, ExpressionTree> extractVarAndConstFromEqualityCheck(ExpressionTree expr) {
        if (expr.kind() == Tree.Kind.EQUAL_TO) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expr;
            ExpressionTree expressionTree = binary.leftOperand();
            if (expressionTree instanceof IdentifierTree) {
                IdentifierTree idTree = (IdentifierTree)expressionTree;
                if (PatternMatchUsingIfCheck.isPossibleConstantForCase(binary.rightOperand())) {
                    return new Pair<IdentifierTree, ExpressionTree>(idTree, binary.rightOperand());
                }
            }
            if ((expressionTree = binary.rightOperand()) instanceof IdentifierTree) {
                IdentifierTree idTree = (IdentifierTree)expressionTree;
                if (PatternMatchUsingIfCheck.isPossibleConstantForCase(binary.leftOperand())) {
                    return new Pair<IdentifierTree, ExpressionTree>(idTree, binary.leftOperand());
                }
            }
        }
        return null;
    }

    private static boolean isPossibleConstantForCase(ExpressionTree expr) {
        return expr.asConstant().isPresent() || expr.symbolType().symbol().isEnum();
    }

    private static ExpressionTree findLeftmostInConjunction(ExpressionTree expr) {
        while (expr.kind() == Tree.Kind.CONDITIONAL_AND) {
            expr = ((BinaryExpressionTree)expr).leftOperand();
        }
        return expr;
    }

    private static void populateGuardsList(ExpressionTree expr, Deque<ExpressionTree> guards) {
        BinaryExpressionTree binary;
        while (expr instanceof BinaryExpressionTree && (binary = (BinaryExpressionTree)expr).kind() == Tree.Kind.CONDITIONAL_AND) {
            guards.addFirst(binary.rightOperand());
            expr = binary.leftOperand();
        }
    }

    private static boolean isElseIf(IfStatementTree ifStat) {
        IfStatementTree parentIf;
        Tree tree = ifStat.parent();
        return tree instanceof IfStatementTree && (parentIf = (IfStatementTree)tree).elseStatement() == ifStat;
    }

    private static boolean hasElseIf(IfStatementTree ifStat) {
        return ifStat.elseStatement() instanceof IfStatementTree;
    }

    private JavaQuickFix computeQuickFix(List<Case> cases, IfStatementTree topLevelIfStat) {
        boolean canLiftReturn = cases.stream().allMatch(caze -> this.exprWhenReturnLifted((Case)caze) != null);
        int baseIndent = topLevelIfStat.firstToken().range().start().column() - 1;
        StringBuilder sb = new StringBuilder();
        if (canLiftReturn) {
            sb.append("return ");
        }
        sb.append("switch (").append(cases.get(0).scrutinee().name()).append(") {\n");
        for (Case caze2 : cases) {
            sb.append(" ".repeat(baseIndent + 2));
            this.writeCase(caze2, sb, baseIndent, canLiftReturn);
            sb.append("\n");
        }
        sb.append(" ".repeat(baseIndent)).append("}");
        if (canLiftReturn) {
            sb.append(";");
        }
        JavaTextEdit edit = JavaTextEdit.replaceTree((Tree)topLevelIfStat, (String)sb.toString());
        return JavaQuickFix.newQuickFix((String)ISSUE_MESSAGE).addTextEdit(new JavaTextEdit[]{edit}).build();
    }

    private void writeCase(Case caze, StringBuilder sb, int baseIndent, boolean canLiftReturn) {
        if (caze instanceof PatternMatchCase) {
            PatternMatchCase patternMatchCase = (PatternMatchCase)caze;
            sb.append("case ").append(QuickFixHelper.contentForTree((Tree)patternMatchCase.pattern, this.context));
            if (!patternMatchCase.guards().isEmpty()) {
                List<ExpressionTree> guards = patternMatchCase.guards();
                sb.append(" when ");
                this.join(guards, " && ", sb);
            }
        } else if (caze instanceof EqualityCase) {
            EqualityCase equalityCase = (EqualityCase)caze;
            sb.append("case ");
            this.join(equalityCase.constants, ", ", sb);
        } else {
            sb.append("default");
        }
        sb.append(" -> ");
        if (canLiftReturn) {
            sb.append(this.exprWhenReturnLifted(caze));
        } else {
            PatternMatchUsingIfCheck.addIndentedExceptFirstLine(this.makeBlockCode(caze.body(), baseIndent), sb);
        }
    }

    private String makeBlockCode(StatementTree stat, int baseIndent) {
        String rawCode = QuickFixHelper.contentForTree((Tree)stat, this.context);
        if (stat instanceof BlockTree) {
            return rawCode;
        }
        return "{\n" + " ".repeat(baseIndent + 2) + rawCode + "\n" + " ".repeat(baseIndent) + "}";
    }

    private static void addIndentedExceptFirstLine(String s, StringBuilder sb) {
        Iterator lines = s.lines().iterator();
        String indentStr = " ".repeat(2);
        sb.append((String)lines.next());
        while (lines.hasNext()) {
            sb.append("\n").append(indentStr).append((String)lines.next());
        }
    }

    private void join(List<? extends Tree> elems, String sep, StringBuilder sb) {
        Iterator<? extends Tree> iter = elems.iterator();
        while (iter.hasNext()) {
            Tree e = iter.next();
            sb.append(QuickFixHelper.contentForTree(e, this.context));
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
    }

    @Nullable
    private String exprWhenReturnLifted(Case caze) {
        ReturnStatementTree returnStat;
        BlockTree block;
        StatementTree stat = caze.body();
        while (stat instanceof BlockTree && (block = (BlockTree)stat).body().size() == 1) {
            stat = (StatementTree)block.body().get(0);
        }
        if (stat instanceof ReturnStatementTree && (returnStat = (ReturnStatementTree)stat).expression() != null) {
            return QuickFixHelper.contentForTree((Tree)returnStat.expression(), this.context) + ";";
        }
        if (stat instanceof ThrowStatementTree) {
            ThrowStatementTree throwStatementTree = (ThrowStatementTree)stat;
            return QuickFixHelper.contentForTree((Tree)throwStatementTree, this.context);
        }
        return null;
    }

    private record DefaultCase(IdentifierTree scrutinee, StatementTree body) implements Case
    {
    }

    private record EqualityCase(IdentifierTree scrutinee, List<ExpressionTree> constants, StatementTree body) implements Case
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Case {
        public IdentifierTree scrutinee();

        public StatementTree body();
    }

    private record PatternMatchCase(IdentifierTree scrutinee, PatternTree pattern, List<ExpressionTree> guards, StatementTree body) implements Case
    {
    }

    private record Pair<A, B>(A a, B b) {
    }
}

