/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.reporting.FluentReporting;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00112", repositoryKey="squid")
@Rule(key="S112")
public class RawExceptionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> RAW_EXCEPTIONS = Arrays.asList("java.lang.Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException");
    private FluentReporting context;
    private final Set<Type> exceptionsThrownByMethodInvocations = new HashSet<Type>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = (FluentReporting)context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree method) {
        super.visitMethod(method);
        if ((method.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR}) || RawExceptionCheck.isNotOverridden(method)) && RawExceptionCheck.isNotMainMethod(method) && RawExceptionCheck.hasNoUnknownMethod(method)) {
            for (TypeTree throwClause : method.throwsClauses()) {
                Type exceptionType = throwClause.symbolType();
                if (!RawExceptionCheck.isRawException(exceptionType) || this.exceptionsThrownByMethodInvocations.contains(exceptionType)) continue;
                this.reportIssue((Tree)throwClause);
            }
        }
        this.exceptionsThrownByMethodInvocations.clear();
    }

    private static boolean hasNoUnknownMethod(MethodTree method) {
        MethodTreeUtils.MethodInvocationCollector unknownMethodVisitor = new MethodTreeUtils.MethodInvocationCollector(Symbol::isUnknown);
        method.accept((TreeVisitor)unknownMethodVisitor);
        return unknownMethodVisitor.getInvocationTree().isEmpty();
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        TypeTree exception;
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && RawExceptionCheck.isRawException((exception = ((NewClassTree)tree.expression()).identifier()).symbolType())) {
            this.reportIssue((Tree)exception);
        }
        super.visitThrowStatement(tree);
    }

    private void reportIssue(Tree tree) {
        this.context.newIssue().forRule((JavaCheck)this).onTree(tree).withMessage("Define and throw a dedicated exception instead of using a generic one.").report();
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        this.collectThrownTypes(mit.methodSymbol());
        super.visitMethodInvocation(mit);
    }

    public void visitNewClass(NewClassTree nct) {
        this.collectThrownTypes(nct.methodSymbol());
        super.visitNewClass(nct);
    }

    private void collectThrownTypes(Symbol.MethodSymbol symbol) {
        if (!symbol.isUnknown()) {
            this.exceptionsThrownByMethodInvocations.addAll(symbol.thrownTypes());
        }
    }

    private static boolean isRawException(Type type) {
        return RAW_EXCEPTIONS.stream().anyMatch(arg_0 -> ((Type)type).is(arg_0));
    }

    private static boolean isNotOverridden(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }

    private static boolean isNotMainMethod(MethodTree tree) {
        return !MethodTreeUtils.isMainMethod(tree);
    }
}

