/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.GuardedPatternTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.NullPatternTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6916")
public class SingleIfInsteadOfPatternMatchGuardCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final String ISSUE_MESSAGE_REPLACE = "Replace this \"if\" statement with a pattern match guard.";
    private static final String ISSUE_MESSAGE_MERGE = "Merge this \"if\" statement with the enclosing pattern match guard.";

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CASE_GROUP);
    }

    public void visitNode(Tree tree) {
        CaseGroupTree caseGroup = (CaseGroupTree)tree;
        IfStatementTree ifStatement = SingleIfInsteadOfPatternMatchGuardCheck.getFirstIfStatementInCaseBody(caseGroup);
        if (ifStatement == null || ifStatement.elseStatement() != null) {
            return;
        }
        CaseLabelTree caseLabel = (CaseLabelTree)caseGroup.labels().get(0);
        if (SingleIfInsteadOfPatternMatchGuardCheck.isCaseDefaultOrNull(caseLabel)) {
            return;
        }
        ExpressionTree caseExpression = (ExpressionTree)caseLabel.expressions().get(0);
        boolean isGuardedPattern = caseExpression instanceof GuardedPatternTree;
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)ifStatement).withMessage(isGuardedPattern ? ISSUE_MESSAGE_MERGE : ISSUE_MESSAGE_REPLACE).withQuickFix(() -> SingleIfInsteadOfPatternMatchGuardCheck.computeQuickFix(ifStatement, caseLabel, isGuardedPattern, this.context)).report();
    }

    private static IfStatementTree getFirstIfStatementInCaseBody(CaseGroupTree caseGroup) {
        Object e;
        BlockTree caseBlock;
        List blockBody;
        Object e2;
        if (!caseGroup.body().isEmpty() && (e2 = caseGroup.body().get(0)) instanceof BlockTree && (blockBody = (caseBlock = (BlockTree)e2).body()).size() == 1 && (e = blockBody.get(0)) instanceof IfStatementTree) {
            IfStatementTree ifStatement = (IfStatementTree)e;
            return ifStatement;
        }
        return null;
    }

    private static boolean isCaseDefaultOrNull(CaseLabelTree caseLabel) {
        return caseLabel.expressions().isEmpty() || caseLabel.expressions().get(0) instanceof NullPatternTree;
    }

    private static JavaQuickFix computeQuickFix(IfStatementTree ifStatement, CaseLabelTree caseLabel, boolean shouldMergeConditions, JavaFileScannerContext context) {
        String replacement;
        BlockTree block;
        JavaQuickFix.Builder quickFixBuilder = JavaQuickFix.newQuickFix((String)(shouldMergeConditions ? ISSUE_MESSAGE_MERGE : ISSUE_MESSAGE_REPLACE));
        StatementTree statementTree = ifStatement.thenStatement();
        if (statementTree instanceof BlockTree && !(block = (BlockTree)statementTree).body().isEmpty()) {
            SyntaxToken firstToken = QuickFixHelper.nextToken((Tree)block.openBraceToken());
            SyntaxToken lastToken = QuickFixHelper.previousToken((Tree)block.closeBraceToken());
            replacement = QuickFixHelper.contentForRange(firstToken, lastToken, context);
        } else {
            replacement = QuickFixHelper.contentForTree((Tree)ifStatement.thenStatement(), context);
        }
        quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)ifStatement, (String)replacement)});
        String replacementStringPrefix = shouldMergeConditions ? " && " : " when ";
        quickFixBuilder.addTextEdit(new JavaTextEdit[]{JavaTextEdit.insertBeforeTree((Tree)caseLabel.colonOrArrowToken(), (String)(replacementStringPrefix + QuickFixHelper.contentForTree((Tree)ifStatement.condition(), context) + " "))});
        return quickFixBuilder.build();
    }
}

