/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5413")
public class SuspiciousListRemoveCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers LIST_REMOVE = MethodMatchers.create().ofTypes(new String[]{"java.util.List"}).names(new String[]{"remove"}).addParametersMatcher(new String[]{"int"}).build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree forStatementTree = (ForStatementTree)tree;
        Symbol counter = SuspiciousListRemoveCheck.findLoopCounter(forStatementTree);
        if (counter == null || !SuspiciousListRemoveCheck.isIncrementingLoop(forStatementTree, counter)) {
            return;
        }
        StatementTree loopBody = forStatementTree.statement();
        LoopBodyVisitor loopBodyVisitor = new LoopBodyVisitor(counter);
        loopBody.accept((TreeVisitor)loopBodyVisitor);
        if (loopBodyVisitor.hasIssue()) {
            this.reportIssue((Tree)loopBodyVisitor.listRemove, "Verify that \"remove()\" is used correctly.");
        }
    }

    @CheckForNull
    private static Symbol findLoopCounter(ForStatementTree forStatementTree) {
        if (forStatementTree.initializer().size() != 1) {
            return null;
        }
        StatementTree initializer = (StatementTree)forStatementTree.initializer().get(0);
        if (!initializer.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return null;
        }
        return ((VariableTree)initializer).symbol();
    }

    private static boolean isIncrementingLoop(ForStatementTree forStatementTree, Symbol counter) {
        if (forStatementTree.update().size() != 1) {
            return false;
        }
        StatementTree loopUpdate = (StatementTree)forStatementTree.update().get(0);
        if (loopUpdate.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ((ExpressionStatementTree)loopUpdate).expression().is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT})) {
            ExpressionTree expression = ((UnaryExpressionTree)((ExpressionStatementTree)loopUpdate).expression()).expression();
            return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && counter.equals((Object)((IdentifierTree)expression).symbol());
        }
        return false;
    }

    private static class LoopBodyVisitor
    extends BaseTreeVisitor {
        private final Symbol counter;
        private MethodInvocationTree listRemove;
        private boolean hasBreakOrContinueOrReturn;
        private boolean isCounterAssigned;

        public LoopBodyVisitor(Symbol counter) {
            this.counter = counter;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (LIST_REMOVE.matches(tree)) {
                this.listRemove = tree;
            }
            super.visitMethodInvocation(tree);
        }

        public void visitBreakStatement(BreakStatementTree tree) {
            this.hasBreakOrContinueOrReturn = true;
            super.visitBreakStatement(tree);
        }

        public void visitContinueStatement(ContinueStatementTree tree) {
            this.hasBreakOrContinueOrReturn = true;
            super.visitContinueStatement(tree);
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.hasBreakOrContinueOrReturn = true;
            super.visitReturnStatement(tree);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.isCounterAssigned |= this.counter.equals((Object)((IdentifierTree)tree.variable()).symbol());
            }
            super.visitAssignmentExpression(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.isCounterAssigned |= this.counter.equals((Object)((IdentifierTree)tree.expression()).symbol());
            }
            super.visitUnaryExpression(tree);
        }

        boolean hasIssue() {
            return this.listRemove != null && !this.hasBreakOrContinueOrReturn && !this.isCounterAssigned;
        }
    }
}

