/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1160")
public class ThrowsSeveralCheckedExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<String> thrownCheckedExceptions;
        MethodTree methodTree = (MethodTree)tree;
        if (ThrowsSeveralCheckedExceptionCheck.isPublic(methodTree) && !MethodTreeUtils.isMainMethod(methodTree) && (thrownCheckedExceptions = ThrowsSeveralCheckedExceptionCheck.getThrownCheckedExceptions(methodTree)).size() > 1 && ThrowsSeveralCheckedExceptionCheck.isNotOverridden(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Refactor this method to throw at most one checked exception instead of: " + String.join((CharSequence)", ", thrownCheckedExceptions));
        }
    }

    private static boolean isNotOverridden(MethodTree methodTree) {
        return Boolean.FALSE.equals(methodTree.isOverriding());
    }

    private static boolean isPublic(MethodTree methodTree) {
        return methodTree.symbol().isPublic();
    }

    private static List<String> getThrownCheckedExceptions(MethodTree methodTree) {
        return methodTree.symbol().thrownTypes().stream().filter(type -> !type.isUnknown() && !ThrowsSeveralCheckedExceptionCheck.isSubClassOfRuntimeException(type)).map(Type::fullyQualifiedName).toList();
    }

    private static boolean isSubClassOfRuntimeException(Type thrownClass) {
        Symbol.TypeSymbol typeSymbol = thrownClass.symbol();
        while (typeSymbol != null) {
            if (ThrowsSeveralCheckedExceptionCheck.isRuntimeException(typeSymbol.type())) {
                return true;
            }
            Type superType = typeSymbol.superClass();
            if (superType == null) {
                typeSymbol = null;
                continue;
            }
            typeSymbol = superType.symbol();
        }
        return false;
    }

    private static boolean isRuntimeException(Type thrownClass) {
        return thrownClass.is("java.lang.RuntimeException");
    }
}

