/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1844")
public class WaitOnConditionCheck
extends AbstractMethodDetection {
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes(new String[]{"java.util.concurrent.locks.Condition"}).names(new String[]{"wait"}).addWithoutParametersMatcher().addParametersMatcher(new String[]{"long"}).addParametersMatcher(new String[]{"long", "int"}).build();
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }

    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        this.reportIssue((Tree)methodReferenceTree.method(), "The \"Condition.await(...)\" method should be used instead of \"Object.wait(...)\"");
    }
}

