/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.design;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6548")
public class SingletonUsageCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "A Singleton implementation was detected. Make sure the use of the Singleton pattern is required and the implementation is the right one for the context.";
    private static final String MESSAGE_FOR_ENUMS = "An Enum-based Singleton implementation was detected. Make sure the use of the Singleton pattern is required and an Enum-based implementation is the right one for the context.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            this.visitClass(classTree);
        } else {
            this.visitEnum(classTree);
        }
    }

    private void visitEnum(ClassTree classTree) {
        EnumConstantTree constant;
        List<Tree> enumConstants = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})).toList();
        if (enumConstants.size() == 1 && SingletonUsageCheck.isInitializedWithParameterFreeConstructor(constant = (EnumConstantTree)enumConstants.get(0)) && SingletonUsageCheck.hasNonPrivateInstanceMethodsOrFields(classTree)) {
            this.reportIssue((Tree)classTree.simpleName(), MESSAGE_FOR_ENUMS, Collections.singletonList(new JavaFileScannerContext.Location("Single enum", (Tree)constant)), null);
        }
    }

    private void visitClass(ClassTree classTree) {
        Map.Entry<ClassTree, VariableTree> classAndInstance = SingletonUsageCheck.collectClassAndField(classTree);
        if (classAndInstance == null) {
            return;
        }
        ClassTree singletonClass = classAndInstance.getKey();
        VariableTree singletonField = classAndInstance.getValue();
        List<MethodTree> allConstructors = singletonClass.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})).map(MethodTree.class::cast).toList();
        if (allConstructors.size() <= 1 && allConstructors.stream().allMatch(constructor -> constructor.symbol().isPrivate() && constructor.parameters().isEmpty()) && SingletonUsageCheck.hasNonPrivateInstanceMethodsOrFields(singletonClass)) {
            ArrayList<JavaFileScannerContext.Location> flows = new ArrayList<JavaFileScannerContext.Location>();
            flows.add(new JavaFileScannerContext.Location("Singleton field", (Tree)singletonField.simpleName()));
            if (singletonClass != classTree) {
                flows.add(new JavaFileScannerContext.Location("Singleton helper", (Tree)classTree.simpleName()));
            }
            allConstructors.forEach(constructor -> {
                IdentifierTree methodName = ((MethodTree)allConstructors.get(0)).simpleName();
                flows.add(new JavaFileScannerContext.Location("Private constructor", (Tree)methodName));
            });
            SingletonUsageCheck.extractAssignments(singletonField).forEach(assignment -> flows.add(new JavaFileScannerContext.Location("Value assignment", (Tree)assignment)));
            this.reportIssue((Tree)singletonClass.simpleName(), MESSAGE, flows, null);
        }
    }

    @CheckForNull
    private static Map.Entry<ClassTree, VariableTree> collectClassAndField(ClassTree classTree) {
        List<VariableTree> staticFields;
        ClassTree wrappingClass = null;
        Tree parent = classTree.parent();
        if (parent != null && parent.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            wrappingClass = (ClassTree)parent;
        }
        if ((staticFields = SingletonUsageCheck.collectStaticFields(classTree, wrappingClass)).size() != 1) {
            return null;
        }
        VariableTree field = staticFields.get(0);
        Symbol fieldSymbol = field.symbol();
        ClassTree singletonClass = null;
        singletonClass = fieldSymbol.type().equals((Object)classTree.symbol().type()) ? classTree : wrappingClass;
        if (!SingletonUsageCheck.isEffectivelyFinal(fieldSymbol)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<ClassTree, VariableTree>(singletonClass, field);
    }

    private static List<VariableTree> collectStaticFields(ClassTree classTree, @Nullable ClassTree wrappingClass) {
        Type type = classTree.symbol().type();
        Type wrappingType = wrappingClass != null ? wrappingClass.symbol().type() : null;
        return classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ((VariableTree)member).symbol().isStatic()).map(VariableTree.class::cast).filter(field -> {
            Type fieldType = field.symbol().type();
            return fieldType.equals((Object)type) || wrappingType != null && fieldType.equals((Object)wrappingType);
        }).toList();
    }

    private static boolean isEffectivelyFinal(Symbol symbol) {
        return symbol.isFinal() || symbol.isPrivate() && ExpressionsHelper.getSingleWriteUsage((Symbol)symbol) != null;
    }

    private static boolean isInitializedWithParameterFreeConstructor(EnumConstantTree constant) {
        return constant.initializer().methodSymbol().parameterTypes().isEmpty();
    }

    private static boolean hasNonPrivateInstanceMethodsOrFields(ClassTree classTree) {
        return classTree.members().stream().anyMatch(member -> {
            if (member.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                Symbol.MethodSymbol symbol = ((MethodTree)member).symbol();
                return !symbol.isPrivate() && !symbol.isStatic();
            }
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                Symbol symbol = ((VariableTree)member).symbol();
                return !symbol.isPrivate() && !symbol.isStatic();
            }
            return false;
        });
    }

    private static List<AssignmentExpressionTree> extractAssignments(VariableTree variable) {
        return variable.symbol().usages().stream().map(Tree::parent).filter(usage -> usage.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})).map(AssignmentExpressionTree.class::cast).toList();
    }
}

