/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6830")
public class SpringBeanNamingConventionCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> ANNOTATIONS_TO_CHECK = List.of("org.springframework.beans.factory.annotation.Qualifier", "org.springframework.context.annotation.Bean", "org.springframework.context.annotation.Configuration", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Component", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Service", "org.springframework.web.bind.annotation.RestController");
    private static final Pattern NAMING_CONVENTION = Pattern.compile("^[a-z][a-zA-Z0-9]*$");

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotation = (AnnotationTree)tree;
        ANNOTATIONS_TO_CHECK.stream().filter(a -> annotation.symbolType().is(a)).findFirst().map(a -> SpringBeanNamingConventionCheck.getNoncompliantNameArgument(annotation)).ifPresent(n -> this.reportIssue((Tree)n, "Rename this bean to match the regular expression '" + NAMING_CONVENTION.pattern() + "'."));
    }

    @CheckForNull
    private static ExpressionTree getNoncompliantNameArgument(AnnotationTree annotation) {
        return annotation.arguments().stream().map(arg -> {
            if (SpringBeanNamingConventionCheck.breaksNamingConvention(SpringBeanNamingConventionCheck.getArgValue(arg))) {
                return arg;
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static ExpressionTree getArgValue(ExpressionTree argument) {
        if (argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)argument;
            String argName = ((IdentifierTree)assignment.variable()).name();
            ExpressionTree argValue = assignment.expression();
            if (argName.equals("name") || argName.equals("value")) {
                return argValue;
            }
        } else {
            return argument;
        }
        return null;
    }

    private static boolean breaksNamingConvention(@Nullable ExpressionTree nameTree) {
        if (nameTree == null) {
            return false;
        }
        String name = (String)ExpressionsHelper.getConstantValueAsString((ExpressionTree)nameTree).value();
        return name != null && !NAMING_CONVENTION.matcher(name).matches();
    }
}

