/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractJUnit5NotCompliantModifierChecker
extends IssuableSubscriptionVisitor {
    protected static final String WRONG_MODIFIER_ISSUE_MESSAGE = "Remove this '%s' modifier.";

    protected abstract boolean isNonCompliantModifier(Modifier var1, boolean var2);

    protected abstract void raiseIssueOnNonCompliantReturnType(MethodTree var1);

    protected void raiseIssueOnNonCompliantModifier(ModifierKeywordTree modifier) {
        QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)modifier).withMessage(String.format(WRONG_MODIFIER_ISSUE_MESSAGE, modifier.keyword().text())).withQuickFix(() -> JavaQuickFix.newQuickFix((String)"Remove modifier").addTextEdit(new JavaTextEdit[]{JavaTextEdit.removeTree((Tree)modifier)}).build()).report();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.symbol().isAbstract()) {
            return;
        }
        List methods = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).collect(Collectors.toCollection(ArrayList::new));
        List<MethodTree> testMethods = methods.stream().filter(UnitTestUtils::hasJUnit5TestAnnotation).filter(AbstractJUnit5NotCompliantModifierChecker::isNotOverriding).toList();
        for (MethodTree testMethod : testMethods) {
            this.raiseIssueOnNotCompliantModifiers(testMethod.modifiers(), true);
            this.raiseIssueOnNonCompliantReturnType(testMethod);
        }
        methods.removeAll(testMethods);
        boolean hasPublicStaticMethods = methods.stream().map(MethodTree::modifiers).anyMatch(AbstractJUnit5NotCompliantModifierChecker::isPublicStatic);
        boolean hasPublicStaticFields = classTree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(VariableTree::modifiers).anyMatch(AbstractJUnit5NotCompliantModifierChecker::isPublicStatic);
        if (hasPublicStaticMethods || hasPublicStaticFields) {
            return;
        }
        if (!testMethods.isEmpty()) {
            this.raiseIssueOnNotCompliantModifiers(classTree.modifiers(), false);
        }
    }

    private static boolean isPublicStatic(ModifiersTree modifiers) {
        return ModifiersUtils.hasAll((ModifiersTree)modifiers, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
    }

    private void raiseIssueOnNotCompliantModifiers(ModifiersTree modifierTree, boolean isMethod) {
        modifierTree.modifiers().stream().filter(modifier -> this.isNonCompliantModifier(modifier.modifier(), isMethod)).findFirst().ifPresent(this::raiseIssueOnNonCompliantModifier);
    }

    private static boolean isNotOverriding(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }
}

