/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.AnnotationsHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1258")
public class AtLeastOneConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> EXCLUDED_ANNOTATIONS = Arrays.asList("javax.annotation.ManagedBean", "javax.ejb.MessageDriven", "javax.ejb.Singleton", "javax.ejb.Stateful", "javax.ejb.Stateless", "javax.jws.WebService", "javax.servlet.annotation.WebFilter", "javax.servlet.annotation.WebServlet", "org.apache.maven.plugins.annotations.Mojo", "org.codehaus.plexus.component.annotations.Component", "lombok.Builder");
    private static final List<String> AUTOWIRED_ANNOTATIONS = Arrays.asList("javax.annotation.Resource", "javax.ejb.EJB", "javax.inject.Inject", "org.apache.maven.plugins.annotations.Component", "org.apache.maven.plugins.annotations.Parameter", "org.codehaus.plexus.component.annotations.Requirement", "org.codehaus.plexus.component.annotations.Configuration");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        this.checkClassTree((ClassTree)tree);
    }

    private void checkClassTree(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (!(simpleName == null || ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT) || AtLeastOneConstructorCheck.isAnnotationExcluded((Symbol)tree.symbol()) || AtLeastOneConstructorCheck.isBuilderPatternName(simpleName.name()))) {
            ArrayList<JavaFileScannerContext.Location> uninitializedVariables = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree member : tree.members()) {
                if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                    return;
                }
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !AtLeastOneConstructorCheck.requiresInitialization((VariableTree)member)) continue;
                uninitializedVariables.add(new JavaFileScannerContext.Location("Uninitialized field", member));
            }
            if (!uninitializedVariables.isEmpty()) {
                this.reportIssue((Tree)simpleName, "Add a constructor to the " + tree.declarationKeyword().text() + ", or provide default values.", uninitializedVariables, null);
            }
        }
    }

    private static boolean requiresInitialization(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return variable.initializer() == null && symbol.isPrivate() && !symbol.isStatic() && !AtLeastOneConstructorCheck.isAutowired(symbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAutowired(Symbol symbol) {
        SymbolMetadata metadata = symbol.metadata();
        if (AnnotationsHelper.hasUnknownAnnotation(metadata)) return true;
        if (!AUTOWIRED_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnnotationExcluded(Symbol symbol) {
        SymbolMetadata metadata = symbol.metadata();
        if (AnnotationsHelper.hasUnknownAnnotation(metadata)) return true;
        if (!EXCLUDED_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0))) return false;
        return true;
    }

    private static boolean isBuilderPatternName(String name) {
        return name.endsWith("Builder");
    }
}

