/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.TreeHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6912")
public class BatchSQLStatementsCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Use \"addBatch\" and \"executeBatch\" to execute multiple SQL statements in a single call.";
    private static final Set<Tree.Kind> LOOP_TREE_KINDS = EnumSet.of(Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT);
    private static final MethodMatchers EXECUTE_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Statement"}).names(new String[]{"execute", "executeQuery", "executeUpdate"}).withAnyParameters().build();
    private static final MethodMatchers FOR_EACH_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.Iterable", "java.util.stream.Stream", "java.util.Map"}).names(new String[]{"forEach"}).withAnyParameters().build();
    private final Set<MethodInvocationTree> invocations = new HashSet<MethodInvocationTree>();

    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.invocations.clear();
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.invocations.forEach(mit -> this.reportIssue((Tree)mit, MESSAGE));
        this.invocations.clear();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return EXECUTE_METHODS;
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (BatchSQLStatementsCheck.hasLoopParent(mit) || BatchSQLStatementsCheck.isLambdaInsideForEach(mit)) {
            this.invocations.add(mit);
        }
    }

    private static boolean hasLoopParent(MethodInvocationTree mit) {
        return Optional.ofNullable(mit.parent()).map(Tree::parent).map(Tree::parent).map(Tree::kind).filter(LOOP_TREE_KINDS::contains).isPresent();
    }

    private static boolean isLambdaInsideForEach(MethodInvocationTree mit) {
        MethodInvocationTree enclosingMit;
        LambdaExpressionTree enclosingLambda;
        Tree tree = TreeHelper.findClosestParentOfKind((Tree)mit, Set.of(Tree.Kind.LAMBDA_EXPRESSION));
        return tree instanceof LambdaExpressionTree && (tree = TreeHelper.findClosestParentOfKind((Tree)(enclosingLambda = (LambdaExpressionTree)tree), Set.of(Tree.Kind.METHOD_INVOCATION))) instanceof MethodInvocationTree && FOR_EACH_MATCHER.matches(enclosingMit = (MethodInvocationTree)tree);
    }
}

