/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1153")
public class ConcatenationWithStringValueOfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            super.visitBinaryExpression(tree);
            return;
        }
        HashSet<MethodInvocationTree> valueOfTrees = new HashSet<MethodInvocationTree>();
        boolean flagIssue = false;
        BinaryExpressionTree current = tree;
        while (current.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binOp = current;
            this.scan((Tree)binOp.rightOperand());
            if (ConcatenationWithStringValueOfCheck.isStringValueOf(binOp.rightOperand())) {
                valueOfTrees.add((MethodInvocationTree)binOp.rightOperand());
            }
            flagIssue |= binOp.leftOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
            if (!valueOfTrees.isEmpty()) {
                flagIssue |= binOp.rightOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
            }
            current = current.leftOperand();
        }
        if (flagIssue) {
            for (MethodInvocationTree valueOfTree : valueOfTrees) {
                QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)valueOfTree).withMessage("Directly append the argument of String.valueOf().").withQuickFix(() -> this.createQuickFix(valueOfTree)).report();
            }
        }
        this.scan((Tree)current);
    }

    private JavaQuickFix createQuickFix(MethodInvocationTree invocationTree) {
        ExpressionTree argumentTree = (ExpressionTree)invocationTree.arguments().get(0);
        Object replacement = QuickFixHelper.contentForTree((Tree)argumentTree, this.context);
        if (argumentTree instanceof BinaryExpressionTree && !argumentTree.symbolType().is("java.lang.String")) {
            replacement = "(" + (String)replacement + ")";
        }
        return JavaQuickFix.newQuickFix((String)"Remove redundant String.valueOf() wrapping").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)invocationTree, (String)replacement)}).build();
    }

    private static boolean isStringValueOf(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && ConcatenationWithStringValueOfCheck.isStringValueOf((MethodInvocationTree)tree);
    }

    private static boolean isStringValueOf(MethodInvocationTree tree) {
        return tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && ConcatenationWithStringValueOfCheck.isStringValueOf((MemberSelectExpressionTree)tree.methodSelect()) && ConcatenationWithStringValueOfCheck.matchArgument(tree.arguments());
    }

    private static boolean matchArgument(Arguments args) {
        return args.size() == 1 && !((ExpressionTree)args.get(0)).symbolType().isUnknown() && !((ExpressionTree)args.get(0)).symbolType().is("char[]");
    }

    private static boolean isStringValueOf(MemberSelectExpressionTree tree) {
        return tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "valueOf".equals(tree.identifier().name()) && "String".equals(((IdentifierTree)tree.expression()).name());
    }
}

