/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.io.File;
import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1598")
public class MismatchPackageDirectoryCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private static final String MESSAGE = "File path \"%s\" should match package name \"%s\". Move the file or change the package name";

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        PackageDeclarationTree packageDeclaration = tree.packageDeclaration();
        if (packageDeclaration == null) {
            return;
        }
        String packageName = PackageUtils.packageName((PackageDeclarationTree)packageDeclaration, (String)File.separator);
        File fileDirectory = this.context.getInputFile().file().getParentFile();
        String fileDirectoryPath = fileDirectory.getPath();
        boolean packageNameIsSuffixOfDirPath = fileDirectoryPath.endsWith(packageName);
        if (packageNameIsSuffixOfDirPath) {
            return;
        }
        File rootProjectWorkingDirectory = null;
        try {
            rootProjectWorkingDirectory = this.context.getRootProjectWorkingDirectory();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String truncatedFilePath = fileDirectoryPath;
        if (rootProjectWorkingDirectory != null) {
            truncatedFilePath = MismatchPackageDirectoryCheck.truncateFileDirectoryPath(fileDirectory, rootProjectWorkingDirectory.getName());
        }
        String issueMessage = String.format(MESSAGE, truncatedFilePath, packageName.replace(File.separator, "."));
        String dirWithoutDots = fileDirectoryPath.replace(".", File.separator);
        if (dirWithoutDots.endsWith(packageName)) {
            this.context.reportIssue((JavaCheck)this, (Tree)packageDeclaration.packageName(), issueMessage + "(Do not use dots in directory names).");
        } else {
            this.context.reportIssue((JavaCheck)this, (Tree)packageDeclaration.packageName(), issueMessage + ".");
        }
    }

    private static String truncateFileDirectoryPath(File fileDirectory, String rootProjectDirectoryName) {
        ArrayList<String> path = new ArrayList<String>();
        while (fileDirectory != null && !fileDirectory.getName().equals(rootProjectDirectoryName)) {
            path.add(0, fileDirectory.getName());
            fileDirectory = fileDirectory.getParentFile();
        }
        return String.join((CharSequence)File.separator, path);
    }
}

