/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4034")
public class PreferStreamAnyMatchCheck
extends AbstractMethodDetection {
    private static final String[] STREAM_TYPES = new String[]{"java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"};
    private static final MethodMatchers FIND_METHODS = MethodMatchers.create().ofTypes(STREAM_TYPES).names(new String[]{"findFirst", "findAny"}).addWithoutParametersMatcher().build();
    private static final MethodMatchers MAP_METHODS = MethodMatchers.create().ofTypes(STREAM_TYPES).names(new String[]{"map"}).addParametersMatcher(new String[]{"java.util.function.Function"}).build();
    private static final MethodMatchers FILTER_METHODS = MethodMatchers.create().ofTypes(STREAM_TYPES).names(new String[]{"filter"}).withAnyParameters().build();
    private static final MethodMatchers BOOLEAN_VALUE = MethodMatchers.create().ofTypes(new String[]{"java.lang.Boolean"}).names(new String[]{"booleanValue"}).addWithoutParametersMatcher().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{"java.util.Optional", "java.util.OptionalInt", "java.util.OptionalLong", "java.util.OptionalDouble"}).names(new String[]{"isPresent"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(STREAM_TYPES).names(new String[]{"anyMatch"}).addParametersMatcher(new String[]{"java.util.function.Predicate"}).build()});
    }

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.methodSymbol().name();
        if ("isPresent".equals(methodName)) {
            this.handleIsPresent(mit);
        } else if ("anyMatch".equals(methodName)) {
            this.handleAnyMatch(mit);
        }
    }

    private void handleAnyMatch(MethodInvocationTree anyMatchMIT) {
        ExpressionTree predicate = (ExpressionTree)anyMatchMIT.arguments().get(0);
        IdentifierTree reportTree = ExpressionUtils.methodName((MethodInvocationTree)anyMatchMIT);
        if (anyMatchMIT.parent().is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            if (predicate.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) && ((LambdaExpressionTree)predicate).body().is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
                this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Replace this double negation with \"allMatch()\" and positive predicate.");
            } else {
                this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Replace this negation and \"anyMatch()\" with \"noneMatch()\".");
            }
        }
        if (predicate.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) && PreferStreamAnyMatchCheck.isBooleanValueReference((MethodReferenceTree)predicate)) {
            PreferStreamAnyMatchCheck.previousMITInChain(anyMatchMIT).filter(arg_0 -> ((MethodMatchers)MAP_METHODS).matches(arg_0)).ifPresent(mapMIT -> this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Use mapper from \"map()\" directly as predicate in \"anyMatch()\"."));
        }
    }

    private static boolean isBooleanValueReference(MethodReferenceTree predicate) {
        return BOOLEAN_VALUE.matches(predicate.method().symbol());
    }

    private void handleIsPresent(MethodInvocationTree isPresentMIT) {
        PreferStreamAnyMatchCheck.previousMITInChain(isPresentMIT).filter(arg_0 -> ((MethodMatchers)FIND_METHODS).matches(arg_0)).ifPresent(findMIT -> PreferStreamAnyMatchCheck.previousMITInChain(findMIT).filter(arg_0 -> ((MethodMatchers)FILTER_METHODS).matches(arg_0)).ifPresent(filterMIT -> this.context.reportIssue((JavaCheck)this, (Tree)ExpressionUtils.methodName((MethodInvocationTree)filterMIT), (Tree)ExpressionUtils.methodName((MethodInvocationTree)isPresentMIT), "Replace this \"filter()." + ExpressionUtils.methodName((MethodInvocationTree)findMIT).name() + "().isPresent()\" chain with \"anyMatch()\".")));
    }

    private static Optional<MethodInvocationTree> previousMITInChain(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree previousInvocation = (MethodInvocationTree)expression;
                return Optional.of(previousInvocation);
            }
        }
        return Optional.empty();
    }
}

