/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2121")
public class SillyStringOperationsCheck
extends AbstractMethodDetection {
    private static final String CHAR_SEQUENCE = "java.lang.CharSequence";
    private static final String STRING = "java.lang.String";
    private static final MethodMatchers STRING_LENGTH = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofTypes(new String[]{STRING}).names(new String[]{"contains"}).addParametersMatcher(params -> params.size() == 1 && ((Type)params.get(0)).isSubtypeOf(CHAR_SEQUENCE)).build(), MethodMatchers.create().ofTypes(new String[]{STRING}).names(new String[]{"compareTo", "compareToIgnoreCase", "endsWith", "indexOf", "lastIndexOf", "matches", "split", "startsWith"}).addParametersMatcher(new String[]{STRING}).build(), MethodMatchers.create().ofTypes(new String[]{STRING}).names(new String[]{"replaceFirst"}).addParametersMatcher(new String[]{STRING, STRING}).build(), MethodMatchers.create().ofTypes(new String[]{STRING}).names(new String[]{"indexOf", "lastIndexOf", "split", "startsWith"}).addParametersMatcher(new String[]{STRING, "int"}).build(), MethodMatchers.create().ofTypes(new String[]{STRING}).names(new String[]{"substring"}).addParametersMatcher(new String[]{"int"}).addParametersMatcher(new String[]{"int", "int"}).build()});
    }

    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            String method;
            ExpressionTree str = ((MemberSelectExpressionTree)tree.methodSelect()).expression();
            Arguments args = tree.arguments();
            if (switch (method = tree.methodSymbol().name()) {
                case "contains", "compareTo", "compareToIgnoreCase", "endsWith", "indexOf", "lastIndexOf", "matches", "split", "startsWith" -> SillyStringOperationsCheck.checkStartsWith(str, args);
                case "replaceFirst" -> SillyStringOperationsCheck.checkReplaceFirst(str, args);
                case "substring" -> SillyStringOperationsCheck.checkSubstring(str, args);
                default -> false;
            }) {
                this.reportIssue((Tree)tree, String.format("Remove this \"%s\" call; it has predictable results.", method));
            }
        }
    }

    private static boolean checkStartsWith(ExpressionTree str, Arguments args) {
        return SillyStringOperationsCheck.isSameString(str, (ExpressionTree)args.get(0));
    }

    private static boolean checkReplaceFirst(ExpressionTree str, Arguments args) {
        return SillyStringOperationsCheck.isSameString(str, (ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isSameString((ExpressionTree)args.get(0), (ExpressionTree)args.get(1));
    }

    private static boolean checkSubstring(ExpressionTree str, Arguments args) {
        if (args.size() == 1) {
            return SillyStringOperationsCheck.isZero((ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(0));
        }
        return SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(0)) || SillyStringOperationsCheck.isZero((ExpressionTree)args.get(0)) && SillyStringOperationsCheck.isStringLength(str, (ExpressionTree)args.get(1));
    }

    private static boolean isSameString(ExpressionTree str, ExpressionTree tree) {
        return SillyStringOperationsCheck.isSameSymbol(str, tree) || SillyStringOperationsCheck.isSameStringLiteral(str, tree);
    }

    private static boolean isSameSymbol(ExpressionTree tree, ExpressionTree other) {
        Symbol s = SillyStringOperationsCheck.symbol(tree);
        return s != null && s.equals((Object)SillyStringOperationsCheck.symbol(other));
    }

    private static boolean isSameStringLiteral(ExpressionTree str, ExpressionTree tree) {
        String s = SillyStringOperationsCheck.string(str);
        return s != null && s.equals(SillyStringOperationsCheck.string(tree));
    }

    private static boolean isZero(ExpressionTree tree) {
        return tree.asConstant(Integer.class).filter(n -> n == 0).isPresent();
    }

    private static boolean isStringLength(ExpressionTree str, ExpressionTree tree) {
        MethodInvocationTree invocation;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && STRING_LENGTH.matches(invocation = (MethodInvocationTree)tree) && invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return SillyStringOperationsCheck.isSameSymbol(str, ((MemberSelectExpressionTree)invocation.methodSelect()).expression());
        }
        return false;
    }

    @CheckForNull
    private static Symbol symbol(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).symbol();
        }
        return null;
    }

    @CheckForNull
    private static String string(ExpressionTree tree) {
        return tree.asConstant(String.class).orElse(null);
    }
}

