/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6915")
public class StringIndexOfRangesCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String BEGIN_IDX_SMALLER_THAN_STR_LENGTH = "Begin index should be smaller than the length of the string.";
    private static final String END_IDX_AT_MOST_STR_LENGTH = "End index should be at most the length of the string.";
    private static final String BEGIN_IDX_NOT_LARGER_THAN_END_IDX = "Begin index should not be larger than endIndex.";
    private static final String END_INDEX = "End index";
    private static final String RECEIVER_STRING = "Receiver string";
    private static final MethodMatchers INDEX_OF_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"indexOf"}).addParametersMatcher(new String[]{"int", "int", "int"}).addParametersMatcher(new String[]{"java.lang.String", "int", "int"}).build();
    private static final MethodMatchers LENGTH_MATCHERS = MethodMatchers.create().ofTypes(new String[]{"java.lang.String"}).names(new String[]{"length"}).addWithoutParametersMatcher().build();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava21Compatible();
    }

    protected MethodMatchers getMethodInvocationMatchers() {
        return INDEX_OF_MATCHERS;
    }

    protected void onMethodInvocationFound(MethodInvocationTree methodInvocation) {
        MemberSelectExpressionTree memberSelect;
        ExpressionTree expressionTree;
        boolean issueFound = this.checkConstantBounds(methodInvocation);
        if (!issueFound && (expressionTree = methodInvocation.methodSelect()) instanceof MemberSelectExpressionTree && (expressionTree = (memberSelect = (MemberSelectExpressionTree)expressionTree).expression()) instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)expressionTree;
            this.checkBoundsThatDependOnLength(methodInvocation, idTree.name());
        }
    }

    private boolean checkConstantBounds(MethodInvocationTree methodInvocation) {
        Optional receiverConst;
        ExpressionTree beginIdxExpr = (ExpressionTree)methodInvocation.arguments().get(1);
        ExpressionTree endIdxExpr = (ExpressionTree)methodInvocation.arguments().get(2);
        Optional beginIdxConst = beginIdxExpr.asConstant(Integer.class);
        Optional endIdxConst = endIdxExpr.asConstant(Integer.class);
        if (beginIdxConst.isPresent() && (Integer)beginIdxConst.get() < 0) {
            this.reportIssue((Tree)beginIdxExpr, "Begin index should be non-negative.");
            return true;
        }
        if (beginIdxConst.isPresent() && endIdxConst.isPresent() && (Integer)beginIdxConst.get() > (Integer)endIdxConst.get()) {
            this.reportWithSecondaryLocation(beginIdxExpr, BEGIN_IDX_NOT_LARGER_THAN_END_IDX, endIdxExpr, END_INDEX);
            return true;
        }
        ExpressionTree expressionTree = methodInvocation.methodSelect();
        if (expressionTree instanceof MemberSelectExpressionTree) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expressionTree;
            v0 = memberSelect.expression().asConstant(String.class);
        } else {
            v0 = receiverConst = Optional.empty();
        }
        if (receiverConst.isPresent() && beginIdxConst.isPresent() && (Integer)beginIdxConst.get() >= ((String)receiverConst.get()).length()) {
            this.reportWithSecondaryLocation(beginIdxExpr, BEGIN_IDX_SMALLER_THAN_STR_LENGTH, methodInvocation.methodSelect(), RECEIVER_STRING);
            return true;
        }
        if (receiverConst.isPresent() && endIdxConst.isPresent() && (Integer)endIdxConst.get() > ((String)receiverConst.get()).length()) {
            this.reportWithSecondaryLocation(endIdxExpr, END_IDX_AT_MOST_STR_LENGTH, methodInvocation.methodSelect(), RECEIVER_STRING);
            return true;
        }
        return false;
    }

    private void checkBoundsThatDependOnLength(MethodInvocationTree methodInvocation, String lengthReceiverVarName) {
        ExpressionTree beginIdxExpr = (ExpressionTree)methodInvocation.arguments().get(1);
        ExpressionTree endIdxExpr = (ExpressionTree)methodInvocation.arguments().get(2);
        Optional<Integer> beginIdxDelta = StringIndexOfRangesCheck.lengthDelta(beginIdxExpr, lengthReceiverVarName);
        Optional<Integer> endIdxDelta = StringIndexOfRangesCheck.lengthDelta(endIdxExpr, lengthReceiverVarName);
        if (beginIdxDelta.isPresent() && beginIdxDelta.get() >= 0) {
            this.reportIssue((Tree)beginIdxExpr, BEGIN_IDX_SMALLER_THAN_STR_LENGTH);
        } else if (endIdxDelta.isPresent() && endIdxDelta.get() > 0) {
            this.reportIssue((Tree)endIdxExpr, END_IDX_AT_MOST_STR_LENGTH);
        } else if (beginIdxDelta.isPresent() && endIdxDelta.isPresent() && beginIdxDelta.get() > endIdxDelta.get()) {
            this.reportWithSecondaryLocation(beginIdxExpr, BEGIN_IDX_NOT_LARGER_THAN_END_IDX, endIdxExpr, END_INDEX);
        }
    }

    private void reportWithSecondaryLocation(ExpressionTree tree, String msg, ExpressionTree secondaryLocation, String secondaryMsg) {
        this.reportIssue((Tree)tree, msg, List.of(new JavaFileScannerContext.Location(secondaryMsg, (Tree)secondaryLocation)), null);
    }

    private static Optional<Integer> lengthDelta(ExpressionTree expr, String varName) {
        if (StringIndexOfRangesCheck.isCallToLengthOnVariable(expr, varName)) {
            return Optional.of(0);
        }
        if (expr instanceof BinaryExpressionTree) {
            boolean isMinus;
            BinaryExpressionTree binaryExpr = (BinaryExpressionTree)expr;
            boolean isPlus = binaryExpr.kind() == Tree.Kind.PLUS;
            boolean bl = isMinus = binaryExpr.kind() == Tree.Kind.MINUS;
            if (!isPlus && !isMinus) {
                return Optional.empty();
            }
            Optional leftCst = binaryExpr.leftOperand().asConstant(Integer.class);
            Optional<Integer> rightCst = binaryExpr.rightOperand().asConstant(Integer.class);
            if (StringIndexOfRangesCheck.isCallToLengthOnVariable(binaryExpr.leftOperand(), varName) && rightCst.isPresent()) {
                return isPlus ? rightCst : rightCst.map(x -> -x.intValue());
            }
            if (isPlus && leftCst.isPresent() && StringIndexOfRangesCheck.isCallToLengthOnVariable(binaryExpr.rightOperand(), varName)) {
                return leftCst;
            }
        }
        return Optional.empty();
    }

    private static boolean isCallToLengthOnVariable(ExpressionTree expr, String varName) {
        if (expr instanceof MethodInvocationTree) {
            IdentifierTree idTree;
            MemberSelectExpressionTree memberSelect;
            ExpressionTree expressionTree;
            MethodInvocationTree mit = (MethodInvocationTree)expr;
            return LENGTH_MATCHERS.matches((Symbol)mit.methodSymbol()) && (expressionTree = mit.methodSelect()) instanceof MemberSelectExpressionTree && (expressionTree = (memberSelect = (MemberSelectExpressionTree)expressionTree).expression()) instanceof IdentifierTree && (idTree = (IdentifierTree)expressionTree).symbol().name().equals(varName);
        }
        return false;
    }
}

