/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.List;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;

public final class SpringUtils {
    public static final String SPRING_SCOPE_ANNOTATION = "org.springframework.context.annotation.Scope";
    public static final String AUTOWIRED_ANNOTATION = "org.springframework.beans.factory.annotation.Autowired";

    private SpringUtils() {
    }

    public static boolean isScopeSingleton(SymbolMetadata clazzMeta) {
        List values = clazzMeta.valuesForAnnotation(SPRING_SCOPE_ANNOTATION);
        if (values == null) {
            return true;
        }
        for (SymbolMetadata.AnnotationValue annotationValue : values) {
            String stringValue;
            Object value;
            if (!"value".equals(annotationValue.name()) && !"scopeName".equals(annotationValue.name()) || !((value = annotationValue.value()) instanceof String) || "singleton".equals(stringValue = (String)value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAutowired(Symbol symbol) {
        return symbol.metadata().isAnnotatedWith(AUTOWIRED_ANNOTATION);
    }
}

