/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1221")
public class MethodNamedHashcodeOrEqualCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        IdentifierTree methodIdentifier = method.simpleName();
        switch (methodIdentifier.name()) {
            case "hashcode": {
                this.reportIfNotOverriding(method, "hashCode()");
                break;
            }
            case "equal": {
                this.reportIfNotOverriding(method, "equals(Object obj)");
                break;
            }
            case "tostring": {
                this.reportIfNotOverriding(method, "toString()");
                break;
            }
        }
    }

    private void reportIfNotOverriding(MethodTree method, String substitute) {
        if (MethodNamedHashcodeOrEqualCheck.notOverriding(method)) {
            this.reportIssue((Tree)method.simpleName(), "Either override Object." + substitute + ", or totally rename the method to prevent any confusion.");
        }
    }

    private static boolean notOverriding(MethodTree method) {
        return Boolean.FALSE.equals(method.isOverriding());
    }
}

